/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.invocation.enterprise;

import jakarta.enterprise.inject.spi.Decorator;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.Bar;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.BarBusiness;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.BarBusinessDecorator;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.Foo;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.FooBusiness;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.FooBusinessDecorator1;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.FooBusinessDecorator2;
import org.jboss.cdi.tck.tests.decorators.invocation.enterprise.FooInterceptor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class EnterpriseDecoratorInvocationTest
extends AbstractTest {
    @Inject
    FooBusiness foo;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseDecoratorInvocationTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{FooInterceptor.class.getName()}).up()).getOrCreateDecorators().clazz(new String[]{FooBusinessDecorator1.class.getName(), FooBusinessDecorator2.class.getName(), BarBusinessDecorator.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method_ee", id="d"), @SpecAssertion(section="decorator_bean_ee", id="d"), @SpecAssertion(section="decorators_ee", id="e"), @SpecAssertion(section="delegate_attribute", id="cc"), @SpecAssertion(section="decorators_ee", id="d"), @SpecAssertion(section="decorators_ee", id="g"), @SpecAssertion(section="decorators_ee", id="f")})
    public void testContextualDecorated() throws Exception {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(FooBusiness.class), new Annotation[0]);
        Assert.assertEquals((int)decorators.size(), (int)2);
        ActionSequence.reset();
        Assert.assertEquals((String)this.foo.businessOperation1(), (String)(Foo.class.getName() + FooBusinessDecorator2.class.getName() + FooBusinessDecorator1.class.getName()));
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)3);
        Assert.assertEquals((String)sequence.get(0), (String)FooInterceptor.class.getName());
        Assert.assertEquals((String)sequence.get(1), (String)FooBusinessDecorator1.class.getName());
        Assert.assertEquals((String)sequence.get(2), (String)FooBusinessDecorator2.class.getName());
        Assert.assertEquals((String)this.foo.businessOperation2(), (String)Foo.class.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method_ee", id="i"), @SpecAssertion(section="decorator_bean_ee", id="d"), @SpecAssertion(section="decorators_ee", id="e")})
    public void testNonContextualDecorated() throws Exception {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(BarBusiness.class), new Annotation[0]);
        Assert.assertEquals((int)decorators.size(), (int)1);
        Assert.assertEquals((int)((Decorator)decorators.iterator().next()).getDecoratedTypes().size(), (int)1);
        ActionSequence.reset();
        Assert.assertEquals((String)this.foo.invokeBarBusinessOperation1(), (String)(Bar.class.getName() + BarBusinessDecorator.class.getName()));
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)2);
        Assert.assertEquals((String)sequence.get(0), (String)FooInterceptor.class.getName());
        Assert.assertEquals((String)sequence.get(1), (String)BarBusinessDecorator.class.getName());
    }
}

