/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.event.complex;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cdi.tck.tests.decorators.builtin.event.complex.Ordered;

public class OrderedEventDeliveryExtension
implements Extension {
    private final Map<ObserverMethod<?>, Integer> observerMethodOrder = new ConcurrentHashMap();

    void processObserverMethod(@Observes ProcessObserverMethod<?, ?> event) {
        ObserverMethod observer = event.getObserverMethod();
        AnnotatedMethod method = event.getAnnotatedMethod();
        int order = 0;
        if (method.isAnnotationPresent(Ordered.class)) {
            Ordered ordered = (Ordered)method.getAnnotation(Ordered.class);
            order = ordered.value();
        }
        this.observerMethodOrder.put(observer, order);
    }

    public int getOrder(ObserverMethod<?> observer) {
        Integer order = this.observerMethodOrder.get(observer);
        if (order == null) {
            return 0;
        }
        return order;
    }
}

