/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.method.definition;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.IllegalProductException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Acorn;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Animal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Apple;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.AppleTree;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BeanWithStaticProducerMethod;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Bite;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Cherry;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DaddyLongLegs;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Deadliest;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlyAnimal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlySpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Egg;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.FunnelWeaver;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Number;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Pollen;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.WolfSpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Yummy;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.cdi.tck.util.DependentInstance;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ProducerMethodDefinitionTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private static final Annotation DEADLIEST_LITERAL = new AnnotationLiteral<Deadliest>(){};
    private static final Annotation NUMBER_LITERAL = new AnnotationLiteral<Number>(){};
    private static final Annotation YUMMY_LITERAL = new AnnotationLiteral<Yummy>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="b"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="a")})
    public void testStaticMethod() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(String.class, TAME_LITERAL).size(), (int)1);
        org.testng.Assert.assertEquals((String)this.getContextualReference(String.class, TAME_LITERAL), (String)BeanWithStaticProducerMethod.getString());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="aa")})
    public void testProducerOnNonBean() throws Exception {
        org.testng.Assert.assertTrue((boolean)this.getBeans(Cherry.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method", id="b")})
    public void testStaticDisposerMethod() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(String.class, TAME_LITERAL).size(), (int)1);
        DependentInstance<String> stringBean = this.newDependentInstance(String.class, TAME_LITERAL);
        org.testng.Assert.assertTrue((boolean)stringBean.get().equals("Pete"));
        stringBean.destroy();
        org.testng.Assert.assertTrue((boolean)BeanWithStaticProducerMethod.stringDestroyed);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method", id="b")})
    public void testStaticDisposerMethodWithNonStaticProducer() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(String.class, NUMBER_LITERAL).size(), (int)1);
        DependentInstance<String> stringBean = this.newDependentInstance(String.class, NUMBER_LITERAL);
        org.testng.Assert.assertTrue((boolean)stringBean.get().equals("number"));
        stringBean.destroy();
        org.testng.Assert.assertTrue((boolean)BeanWithStaticProducerMethod.numberDestroyed);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method", id="b")})
    public void testNonStaticDisposerMethodWithStaticProducer() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(String.class, YUMMY_LITERAL).size(), (int)1);
        DependentInstance<String> stringBean = this.newDependentInstance(String.class, YUMMY_LITERAL);
        org.testng.Assert.assertTrue((boolean)stringBean.get().equals("yummy"));
        stringBean.destroy();
        org.testng.Assert.assertTrue((boolean)BeanWithStaticProducerMethod.yummyDestroyed);
    }

    @Test
    @SpecAssertion(section="producer_method", id="ga")
    public void testParameterizedReturnType() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(new TypeLiteral<FunnelWeaver<Spider>>(){}, new Annotation[0]).size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="c"), @SpecAssertion(section="declaring_producer_method", id="a"), @SpecAssertion(section="builtin_qualifiers", id="aa"), @SpecAssertion(section="builtin_qualifiers", id="ab")})
    public void testDefaultBindingType() throws Exception {
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).size(), (int)1);
        org.testng.Assert.assertEquals((int)((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().size(), (int)2);
        org.testng.Assert.assertTrue((boolean)((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains(Default.Literal.INSTANCE));
        org.testng.Assert.assertTrue((boolean)((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_types", id="c"), @SpecAssertion(section="bean_types", id="l")})
    public void testApiTypeForClassReturn() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(Tarantula.class, new Annotation[0]).size(), (int)1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        org.testng.Assert.assertEquals((int)tarantula.getTypes().size(), (int)6);
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(Tarantula.class));
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(DeadlySpider.class));
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(Spider.class));
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(Animal.class));
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(DeadlyAnimal.class));
        org.testng.Assert.assertTrue((boolean)tarantula.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_method_types", id="a")
    public void testApiTypeForInterfaceReturn() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(Bite.class, new Annotation[0]).size(), (int)1);
        Bean<Bite> animal = this.getBeans(Bite.class, new Annotation[0]).iterator().next();
        org.testng.Assert.assertEquals((int)animal.getTypes().size(), (int)2);
        org.testng.Assert.assertTrue((boolean)animal.getTypes().contains(Bite.class));
        org.testng.Assert.assertTrue((boolean)animal.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_method_types", id="ba")
    public void testApiTypeForPrimitiveReturn() throws Exception {
        Set<Bean<Integer>> beans = this.getBeans(Integer.class, NUMBER_LITERAL);
        org.testng.Assert.assertEquals((int)beans.size(), (int)1);
        Bean<Integer> bean = beans.iterator().next();
        Assert.assertTypeSetMatches(bean.getTypes(), new Type[]{Object.class, Integer.TYPE});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_types", id="bb"), @SpecAssertion(section="legal_bean_types", id="i")})
    public void testApiTypeForArrayTypeReturn() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(Spider[].class, new Annotation[0]).size(), (int)1);
        Bean<Spider[]> spiders = this.getBeans(Spider[].class, new Annotation[0]).iterator().next();
        org.testng.Assert.assertEquals((int)spiders.getTypes().size(), (int)2);
        org.testng.Assert.assertTrue((boolean)spiders.getTypes().contains(Spider[].class));
        org.testng.Assert.assertTrue((boolean)spiders.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="be"), @SpecAssertion(section="producer_method", id="k"), @SpecAssertion(section="declaring_bean_qualifiers", id="b")})
    public void testBindingType() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(Tarantula.class, TAME_LITERAL).size(), (int)1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, TAME_LITERAL).iterator().next();
        org.testng.Assert.assertEquals((int)tarantula.getQualifiers().size(), (int)2);
        org.testng.Assert.assertTrue((boolean)tarantula.getQualifiers().contains(TAME_LITERAL));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="ba"), @SpecAssertion(section="producer_method", id="k")})
    public void testScopeType() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(DaddyLongLegs.class, TAME_LITERAL).size(), (int)1);
        Bean<DaddyLongLegs> daddyLongLegs = this.getBeans(DaddyLongLegs.class, TAME_LITERAL).iterator().next();
        org.testng.Assert.assertEquals((Object)daddyLongLegs.getScope(), RequestScoped.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="bb"), @SpecAssertion(section="declaring_bean_name", id="b")})
    public void testNamedMethod() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(BlackWidow.class, TAME_LITERAL).size(), (int)1);
        Bean<BlackWidow> blackWidowSpider = this.getBeans(BlackWidow.class, TAME_LITERAL).iterator().next();
        org.testng.Assert.assertEquals((String)blackWidowSpider.getName(), (String)"blackWidow");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="bb"), @SpecAssertion(section="default_name", id="b"), @SpecAssertion(section="default_name", id="fb")})
    public void testDefaultNamedMethod() throws Exception {
        String name = "produceDaddyLongLegs";
        Bean<DaddyLongLegs> daddyLongLegs = this.getUniqueBean(DaddyLongLegs.class, TAME_LITERAL);
        org.testng.Assert.assertEquals((String)daddyLongLegs.getName(), (String)name);
        org.testng.Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)daddyLongLegs.getQualifiers(), new Annotation[]{Any.Literal.INSTANCE, TAME_LITERAL, NamedLiteral.of((String)name)}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="b"), @SpecAssertion(section="declaring_producer_method", id="ba"), @SpecAssertion(section="default_scope", id="c"), @SpecAssertion(section="declaring_producer_method", id="bd")})
    public void testStereotypeSpecifiesScope() throws Exception {
        org.testng.Assert.assertEquals((int)this.getBeans(WolfSpider.class, TAME_LITERAL).size(), (int)1);
        Bean<WolfSpider> wolfSpider = this.getBeans(WolfSpider.class, TAME_LITERAL).iterator().next();
        org.testng.Assert.assertEquals((Object)wolfSpider.getScope(), RequestScoped.class);
    }

    @Test(expectedExceptions={UnsatisfiedResolutionException.class})
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="da"), @SpecAssertion(section="specialization", id="cb")})
    public void testNonStaticProducerMethodNotInheritedBySpecializingSubclass() {
        org.testng.Assert.assertEquals((int)this.getBeans(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size(), (int)0);
        this.getContextualReference(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="da"), @SpecAssertion(section="member_level_inheritance", id="dg")})
    public void testNonStaticProducerMethodNotInherited() {
        org.testng.Assert.assertEquals((int)this.getBeans(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size(), (int)1);
        org.testng.Assert.assertEquals(this.getContextualReference(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).getTree().getClass(), AppleTree.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="method_constructor_parameter_qualifiers", id="a"), @SpecAssertion(section="declaring_producer_method", id="i"), @SpecAssertion(section="declaring_producer_method", id="h"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="e")})
    public void testBindingTypesAppliedToProducerMethodParameters() {
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantula);
        Tarantula instance = (Tarantula)tarantula.create(creationalContext);
        org.testng.Assert.assertEquals((int)instance.getDeathsCaused(), (int)1);
    }

    @Test
    @SpecAssertion(section="producer_method", id="e")
    public void testDependentProducerReturnsNullValue() {
        org.testng.Assert.assertEquals((Object)this.getContextualReference(Acorn.class, new Annotation[0]), null);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="producer_method", id="f")
    public void testNonDependentProducerReturnsNullValue() {
        this.getContextualReference(Pollen.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).ping();
        org.testng.Assert.fail((String)"IllegalProductException not thrown");
    }

    @Test
    @SpecAssertion(section="producer_method", id="iaa")
    public void testTypeVariableReturnType() {
        org.testng.Assert.assertEquals((int)this.getBeans(new TypeLiteral<List<Spider>>(){}, new Annotation[0]).size(), (int)1);
    }
}

