/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injectionpoint;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Animal;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.AnimalDecorator1;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.AnimalDecorator2;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.AnimalDecorator3;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.AnimalStereotype;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Baz;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.BeanWithInjectionPointMetadata;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Cat;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Cattery;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.ConstructorInjectionPointBean;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.FieldInjectionPointBean;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Foo;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.MethodInjectionPointBean;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.Toy;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.TransientFieldInjectionPointBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InjectionPointTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionPointTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateDecorators().clazz(new String[]{AnimalDecorator1.class.getName(), AnimalDecorator2.class.getName(), AnimalDecorator3.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="contextual_reference", id="da"), @SpecAssertion(section="injection_point", id="aa")})
    public void testGetBean() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        Set<Bean<FieldInjectionPointBean>> resolvedBeans = this.getBeans(FieldInjectionPointBean.class, new Annotation[0]);
        assert (resolvedBeans.size() == 1);
        assert (beanWithInjectionPoint.getInjectedMetadata().getBean().equals(resolvedBeans.iterator().next()));
    }

    @Test
    @SpecAssertion(section="contextual_reference", id="db")
    public void testNullInjectionPointInjectedIntoNonInjectedObject() {
        Foo foo = this.getContextualReference(Foo.class, new Annotation[0]);
        Assert.assertTrue((boolean)foo.isEveryInjectionPointNull(), (String)"A non-null value of InjectionPoint injected into a dependent object that is not being injected.");
        this.getContextualReference(Baz.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="injection_point", id="ba")
    public void testGetType() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (beanWithInjectionPoint.getInjectedMetadata().getType().equals(BeanWithInjectionPointMetadata.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="bc")
    public void testGetBindingTypes() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        Set bindingTypes = beanWithInjectionPoint.getInjectedMetadata().getQualifiers();
        assert (bindingTypes.size() == 1);
        assert (Default.class.isAssignableFrom(((Annotation)bindingTypes.iterator().next()).annotationType()));
    }

    @Test
    @SpecAssertion(section="injection_point", id="ca")
    public void testGetMemberField() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (Field.class.isAssignableFrom(beanWithInjectionPoint.getInjectedMetadata().getMember().getClass()));
    }

    @Test
    @SpecAssertion(section="injection_point", id="cb")
    public void testGetMemberMethod() {
        MethodInjectionPointBean beanWithInjectedBean = this.getContextualReference(MethodInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (Method.class.isAssignableFrom(beanWithInjectionPoint.getInjectedMetadata().getMember().getClass()));
        assert (beanWithInjectionPoint.getInjectedMetadata().getType().equals(BeanWithInjectionPointMetadata.class));
        assert (beanWithInjectionPoint.getInjectedMetadata().getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="injection_point", id="cc")
    public void testGetMemberConstructor() {
        ConstructorInjectionPointBean beanWithInjectedBean = this.getContextualReference(ConstructorInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (Constructor.class.isAssignableFrom(beanWithInjectionPoint.getInjectedMetadata().getMember().getClass()));
        assert (beanWithInjectionPoint.getInjectedMetadata().getType().equals(BeanWithInjectionPointMetadata.class));
        assert (beanWithInjectionPoint.getInjectedMetadata().getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="injection_point", id="daa")
    public void testGetAnnotatedField() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (beanWithInjectionPoint.getInjectedMetadata().getAnnotated() instanceof AnnotatedField);
        assert (beanWithInjectionPoint.getInjectedMetadata().getAnnotated().isAnnotationPresent(AnimalStereotype.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="daa")
    public void testGetAnnotatedParameter() {
        MethodInjectionPointBean beanWithInjectedBean = this.getContextualReference(MethodInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (beanWithInjectionPoint.getInjectedMetadata().getAnnotated() instanceof AnnotatedParameter);
        assert (this.annotationSetMatches((Set<? extends Annotation>)beanWithInjectionPoint.getInjectedMetadata().getQualifiers(), Default.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="ea")
    public void testDependentScope() {
        assert (this.getBeans(InjectionPoint.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(InjectionPoint.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="eb")
    public void testPassivationCapability() throws Exception {
        InjectionPoint ip1 = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        InjectionPoint ip2 = this.getContextualReference(MethodInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        InjectionPoint ip3 = this.getContextualReference(ConstructorInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        ip1 = (InjectionPoint)this.activate(this.passivate(ip1));
        ip2 = (InjectionPoint)this.activate(this.passivate(ip2));
        ip3 = (InjectionPoint)this.activate(this.passivate(ip3));
        assert (ip1.getType().equals(BeanWithInjectionPointMetadata.class));
        assert (ip2.getType().equals(BeanWithInjectionPointMetadata.class));
        assert (ip3.getType().equals(BeanWithInjectionPointMetadata.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="ea")
    public void testApiTypeInjectionPoint() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (InjectionPoint.class.isAssignableFrom(beanWithInjectionPoint.getInjectedMetadata().getClass()));
    }

    @Test
    @SpecAssertion(section="injection_point", id="ea")
    public void testCurrentBinding() {
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        assert (beanWithInjectionPoint.getInjectedMetadata() != null);
        assert (beanWithInjectionPoint.getInjectedMetadata().getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="injection_point", id="dca")
    public void testIsTransient() {
        FieldInjectionPointBean bean1 = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        TransientFieldInjectionPointBean bean2 = this.getContextualReference(TransientFieldInjectionPointBean.class, new Annotation[0]);
        InjectionPoint ip1 = bean1.getInjectedBean().getInjectedMetadata();
        InjectionPoint ip2 = bean2.getInjectedBean().getInjectedMetadata();
        assert (!ip1.isTransient());
        assert (ip2.isTransient());
    }

    @Test
    @SpecAssertion(section="injection_point", id="dba")
    public void testIsDelegate() {
        assert (!this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata().isDelegate());
        Cat cat = this.getContextualReference(Cattery.class, new Annotation[0]).getCat();
        assert (cat.hello().equals("hello!!!"));
        assert (cat.getBeanManager() != null);
        assert (cat.getInjectionPoint() != null);
        assert (!cat.getInjectionPoint().isDelegate());
        List animalDecorators = this.getCurrentManager().resolveDecorators(Collections.singleton(Animal.class), new Annotation[0]);
        assert (animalDecorators.size() == 3);
        for (Decorator animalDecorator : animalDecorators) {
            assert (animalDecorator.getInjectionPoints().size() == 2);
            for (InjectionPoint injectionPoint : animalDecorator.getInjectionPoints()) {
                if (injectionPoint.getType().equals(InjectionPoint.class)) {
                    Assert.assertFalse((boolean)injectionPoint.isDelegate());
                    continue;
                }
                if (injectionPoint.getType().equals(Animal.class)) {
                    Assert.assertTrue((boolean)injectionPoint.isDelegate());
                    continue;
                }
                if (injectionPoint.getType().equals(Toy.class)) {
                    Assert.assertFalse((boolean)injectionPoint.isDelegate());
                    continue;
                }
                assert (false);
            }
        }
        Toy toy = cat.getToy();
        assert (toy.getInjectionPoint() != null);
        assert (toy.getInjectionPoint().getBean().getBeanClass().equals(AnimalDecorator2.class));
    }
}

