/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer;

import jakarta.enterprise.context.spi.Context;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.AnEventType;
import org.jboss.cdi.tck.tests.event.observer.AnObserver;
import org.jboss.cdi.tck.tests.event.observer.AnotherObserver;
import org.jboss.cdi.tck.tests.event.observer.DisabledObserver;
import org.jboss.cdi.tck.tests.event.observer.LastObserver;
import org.jboss.cdi.tck.tests.event.observer.RoleLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class ObserverNotificationTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ObserverNotificationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_resolution", id="c"), @SpecAssertion(section="observer_resolution", id="d"), @SpecAssertion(section="observer_notification", id="aa")})
    public void testObserversNotified() {
        AnEventType anEvent = new AnEventType();
        this.resetObservers();
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[]{new RoleLiteral("Admin", "hurray")});
        Assert.assertTrue((boolean)AnObserver.wasNotified);
        Assert.assertTrue((boolean)AnotherObserver.wasNotified);
        Assert.assertTrue((boolean)LastObserver.wasNotified);
        Assert.assertFalse((boolean)DisabledObserver.wasNotified);
        this.resetObservers();
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[0]);
        Assert.assertTrue((boolean)AnObserver.wasNotified);
        Assert.assertFalse((boolean)AnotherObserver.wasNotified);
        Assert.assertTrue((boolean)LastObserver.wasNotified);
        Assert.assertFalse((boolean)DisabledObserver.wasNotified);
        this.resetObservers();
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[]{new RoleLiteral("user", "hurray")});
        Assert.assertTrue((boolean)AnObserver.wasNotified);
        Assert.assertFalse((boolean)AnotherObserver.wasNotified);
        Assert.assertTrue((boolean)LastObserver.wasNotified);
        Assert.assertFalse((boolean)DisabledObserver.wasNotified);
    }

    @Test
    @SpecAssertion(section="observer_notification", id="bca")
    public void testObserverMethodNotInvokedIfNoActiveContext() {
        Context requestContext = this.getCurrentConfiguration().getContexts().getRequestContext();
        this.resetObservers();
        try {
            this.setContextInactive(requestContext);
            this.getCurrentManager().fireEvent((Object)new AnEventType(), new Annotation[]{new RoleLiteral("Admin", "hurray")});
            Assert.assertFalse((boolean)AnotherObserver.wasNotified);
        }
        finally {
            this.setContextActive(requestContext);
        }
    }

    private void resetObservers() {
        AnObserver.wasNotified = false;
        AnotherObserver.wasNotified = false;
        LastObserver.wasNotified = false;
    }
}

