/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.CharArrays;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharArrayAssert<SELF extends AbstractCharArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, char[], Character> {
    @VisibleForTesting
    protected CharArrays arrays = CharArrays.instance();

    public AbstractCharArrayAssert(char[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (char[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (char[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (char[])this.actual);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (char[])this.actual, expected);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (char[])this.actual, other);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF contains(char ... values) {
        this.arrays.assertContains(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsOnly(char ... values) {
        this.arrays.assertContainsOnly(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(char ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsSequence(char ... sequence) {
        this.arrays.assertContainsSequence(this.info, (char[])this.actual, sequence);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsSubsequence(char ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (char[])this.actual, subsequence);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF contains(char value, Index index) {
        this.arrays.assertContains(this.info, (char[])this.actual, value, index);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF doesNotContain(char ... values) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF doesNotContain(char value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, value, index);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (char[])this.actual);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF startsWith(char ... sequence) {
        this.arrays.assertStartsWith(this.info, (char[])this.actual, sequence);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF endsWith(char ... sequence) {
        this.arrays.assertEndsWith(this.info, (char[])this.actual, sequence);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (char[])this.actual);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Character> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (char[])this.actual, comparator);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Character> customComparator) {
        this.arrays = new CharArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = CharArrays.instance();
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsExactly(char ... values) {
        this.arrays.assertContainsExactly(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(char ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (char[])this.actual, values);
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }

    @CheckReturnValue
    public SELF inUnicode() {
        this.info.useUnicodeRepresentation();
        return (SELF)((AbstractCharArrayAssert)this.myself);
    }
}

