/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;
import org.assertj.core.util.diff.DiffUtils;
import org.assertj.core.util.diff.Patch;

@VisibleForTesting
public class Diff {
    @VisibleForTesting
    public List<Delta<String>> diff(InputStream actual, InputStream expected) throws IOException {
        return this.diff(this.readerFor(actual), this.readerFor(expected));
    }

    @VisibleForTesting
    public List<Delta<String>> diff(File actual, Charset actualCharset, File expected, Charset expectedCharset) throws IOException {
        return this.diff(actual.toPath(), actualCharset, expected.toPath(), expectedCharset);
    }

    @VisibleForTesting
    public List<Delta<String>> diff(Path actual, Charset actualCharset, Path expected, Charset expectedCharset) throws IOException {
        return this.diff(Files.newBufferedReader(actual, actualCharset), Files.newBufferedReader(expected, expectedCharset));
    }

    @VisibleForTesting
    public List<Delta<String>> diff(File actual, String expected, Charset charset) throws IOException {
        return this.diff(actual.toPath(), expected, charset);
    }

    @VisibleForTesting
    public List<Delta<String>> diff(Path actual, String expected, Charset charset) throws IOException {
        return this.diff(Files.newBufferedReader(actual, charset), this.readerFor(expected));
    }

    private BufferedReader readerFor(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
    }

    private BufferedReader readerFor(String string) {
        return new BufferedReader(new StringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Delta<String>> diff(BufferedReader actual, BufferedReader expected) throws IOException {
        List<Delta<String>> list;
        try {
            List<String> actualLines = this.linesFromBufferedReader(actual);
            List<String> expectedLines = this.linesFromBufferedReader(expected);
            Patch<String> patch = DiffUtils.diff(expectedLines, actualLines);
            list = Collections.unmodifiableList(patch.getDeltas());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(actual, expected);
            throw throwable;
        }
        Closeables.closeQuietly(actual, expected);
        return list;
    }

    private List<String> linesFromBufferedReader(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }
}

