/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.common.IResourceSetProcessor;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.internal.IDebugger;
import org.eclipse.emf.edapt.internal.migration.internal.IOracle;
import org.eclipse.emf.edapt.internal.migration.internal.MigratorOptions;
import org.eclipse.emf.edapt.internal.migration.internal.Persistency;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.migration.ui.InteractiveDebugger;
import org.eclipse.emf.edapt.migration.ui.InteractiveOracle;
import org.eclipse.emf.edapt.migration.ui.ReleaseDialog;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class MigratorHandlerBase
extends AbstractHandler {
    private List<IFile> selectedFiles;

    public Object execute(ExecutionEvent event) {
        this.updateSelection(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        this.run();
        return null;
    }

    protected void run() {
        List<URI> modelURIs = this.getURIs();
        Migrator migrator = this.getMigrator(modelURIs);
        if (migrator == null) {
            return;
        }
        Release release = this.getRelease(modelURIs, migrator);
        if (release == null) {
            return;
        }
        this.run(modelURIs, migrator, release);
    }

    protected abstract void run(List<URI> var1, Migrator var2, Release var3);

    protected Migrator getMigrator(List<URI> modelURIs) {
        if (modelURIs.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Namespace", (String)"Not a valid model");
            return null;
        }
        MigratorOptions.getInstance().setOracle((IOracle)new InteractiveOracle());
        MigratorOptions.getInstance().setDebugger((IDebugger)new InteractiveDebugger());
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURIs.get(0));
        if (nsURI == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Namespace", (String)"Not a valid model");
            return null;
        }
        Migrator migrator = this.getRegistryMigrator(nsURI);
        return migrator;
    }

    private Migrator getRegistryMigrator(String nsURI) {
        Migrator migrator = MigratorRegistry.getInstance().getMigrator(nsURI);
        if (migrator == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Migrator", (String)"No migrator registered for model with that namespace");
            return null;
        }
        return migrator;
    }

    protected Release getRelease(List<URI> modelURIs, Migrator migrator) {
        HashSet<Release> releases = new HashSet<Release>(migrator.getRelease(modelURIs.get(0)));
        Release release = null;
        if (releases.size() > 1) {
            Iterator i = releases.iterator();
            while (i.hasNext()) {
                Release r = (Release)i.next();
                Metamodel metamodel = migrator.getMetamodel(r);
                try {
                    Model model = Persistency.loadModel(modelURIs, (Metamodel)metamodel, (IResourceSetFactory)migrator.getResourceSetFactory(), (IResourceSetProcessor)migrator.getPostLoadModelProcessor());
                    model.checkConformance();
                }
                catch (Exception e) {
                    i.remove();
                }
            }
        }
        if (releases.size() > 1) {
            ReleaseDialog dialog = new ReleaseDialog(releases);
            if (dialog.open() != 0) {
                return null;
            }
            release = dialog.getRelease();
        } else {
            release = (Release)releases.iterator().next();
        }
        return release;
    }

    protected List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (IFile file : this.selectedFiles) {
            uris.add(URIUtils.getURI((IResource)file));
        }
        return uris;
    }

    private void updateSelection(ISelection selection) {
        this.selectedFiles = SelectionUtils.getSelectedElements((ISelection)selection, IFile.class);
    }

    protected List<IFile> getSelectedFiles() {
        return this.selectedFiles;
    }
}

