/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.history.instantiation.ui.ReleaseWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ReleaseWizard
extends Wizard {
    private final Map<EPackage, Boolean> updateMap = new LinkedHashMap<EPackage, Boolean>();
    private final Map<EPackage, String> sourceMap = new LinkedHashMap<EPackage, String>();
    private final Map<EPackage, String> targetMap = new LinkedHashMap<EPackage, String>();
    private final List<EPackage> rootPackages;
    private final Set<EPackage> changedPackages;
    private ReleaseWizardPage releaseWizardPage;

    public ReleaseWizard(List<EPackage> rootPackages, Set<EPackage> changedPackages) {
        if (rootPackages == null || rootPackages.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one root package.");
        }
        this.rootPackages = rootPackages;
        this.changedPackages = changedPackages;
    }

    public String getWindowTitle() {
        return "Create Release";
    }

    public void addPages() {
        ArrayList<EPackage> sources = new ArrayList<EPackage>(this.rootPackages);
        this.releaseWizardPage = new ReleaseWizardPage("Update namespace URI of package(s)", "Enter the label(s) to replace and the target label or deselect the update button", null, sources, this.changedPackages);
        this.addPage((IWizardPage)this.releaseWizardPage);
    }

    public boolean updatePackage(EPackage ePackage) {
        if (!this.updateMap.containsKey(ePackage)) {
            return false;
        }
        return this.updateMap.get(ePackage);
    }

    public String getSource(EPackage ePackage) {
        return this.sourceMap.get(ePackage);
    }

    public String getTarget(EPackage ePackage) {
        return this.targetMap.get(ePackage);
    }

    public boolean performFinish() {
        for (EPackage ePackage : this.rootPackages) {
            boolean isUpdate = this.releaseWizardPage.isUpdate(ePackage);
            this.updateMap.put(ePackage, isUpdate);
            if (!isUpdate) continue;
            this.sourceMap.put(ePackage, this.releaseWizardPage.getSource(ePackage));
            this.targetMap.put(ePackage, this.releaseWizardPage.getTarget(ePackage));
        }
        this.releaseWizardPage = null;
        return true;
    }
}

