/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.cdo.migration;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.util.CDOFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.migration.internal.BackwardConverter;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.Type;

public class StrategyBackwardConverter
extends BackwardConverter {
    private EFactory eFactory;
    private final List<URI> targetURI;
    private final MetamodelExtent extent;

    protected void createObjects(Type type) {
        EClass sourceClass = type.getEClass();
        EClass targetClass = this.resolveEClass(sourceClass);
        for (Instance element : type.getInstances()) {
            EFactory eFactoryInstance = targetClass.getEPackage().getEFactoryInstance();
            EObject eObject = null;
            if (eFactoryInstance instanceof CDOFactory) {
                if (this.eFactory == null) {
                    Collection rootPackages = this.extent.getRootPackages();
                    for (EPackage ePack : rootPackages) {
                        this.eFactory = ePack.getEFactoryInstance();
                    }
                }
                if (this.eFactory != null) {
                    eObject = this.eFactory.create(targetClass);
                }
            }
            if (eObject == null) {
                eObject = EcoreUtil.create((EClass)targetClass);
            }
            if (element.isProxy()) {
                ((InternalEObject)eObject).eSetProxyURI(element.getUri());
            }
            this.mapping.put((Object)element, (Object)eObject);
        }
    }

    public StrategyBackwardConverter(MetamodelExtent extent, List<URI> list) {
        this.targetURI = list;
        this.extent = extent;
    }

    protected ResourceSet initResources(Model model) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ResourceUtils.register((List)model.getMetamodel().getEPackages(), (EPackage.Registry)resourceSet.getPackageRegistry());
        for (ModelResource modelResource : model.getResources()) {
            URI target = this.targetURI.get(0);
            Resource resource = resourceSet.createResource(target);
            if (resource instanceof XMLResource) {
                XMLResource xmlResource = (XMLResource)resource;
                if (modelResource.getEncoding() != null) {
                    xmlResource.setEncoding(modelResource.getEncoding());
                }
            }
            for (Instance element : modelResource.getRootInstances()) {
                EObject resolve = this.resolve(element);
                resource.getContents().add((Object)resolve);
            }
        }
        return resourceSet;
    }
}

