/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.execution.internal;

import java.lang.reflect.Field;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.ParameterInstance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MetamodelResource;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.Repository;

public class OperationInstanceConverter {
    public static Repository createEmptyRepository(MetamodelExtent extent) {
        Repository repository = MigrationFactory.eINSTANCE.createRepository();
        Metamodel metamodel = MigrationFactory.eINSTANCE.createMetamodel();
        MetamodelResource resource = MigrationFactory.eINSTANCE.createMetamodelResource();
        metamodel.getResources().add((Object)resource);
        resource.getRootPackages().addAll(extent.getRootPackages());
        Model model = MigrationFactory.eINSTANCE.createModel();
        model.setMetamodel(metamodel);
        repository.setMetamodel(metamodel);
        repository.setModel(model);
        return repository;
    }

    public static OperationImplementation convert(OperationInstance operationInstance, Metamodel metamodel) {
        try {
            Operation operation = operationInstance.getOperation();
            Parameter mainParameter = operation.getMainParameter();
            OperationImplementation operationImpl = (OperationImplementation)operation.getImplementation().newInstance();
            ParameterInstance mainParameterInstance = operationInstance.getParameter(mainParameter.getName());
            OperationInstanceConverter.transfer(mainParameterInstance, operationImpl);
            try {
                operationImpl.initialize(metamodel);
            }
            catch (RuntimeException runtimeException) {}
            for (ParameterInstance parameterInstance : operationInstance.getParameters()) {
                if (parameterInstance == mainParameterInstance) continue;
                OperationInstanceConverter.transfer(parameterInstance, operationImpl);
            }
            return operationImpl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void transfer(ParameterInstance parameterInstance, OperationImplementation operationBase) throws NoSuchFieldException, IllegalAccessException {
        Field field = operationBase.getClass().getField(parameterInstance.getName());
        if (parameterInstance.getValue() != null) {
            field.set(operationBase, parameterInstance.getValue());
        }
    }

    public static void convert(OperationImplementation operationBase, OperationInstance operationInstance) {
        try {
            for (ParameterInstance parameterInstance : operationInstance.getParameters()) {
                Field field = operationBase.getClass().getField(parameterInstance.getName());
                parameterInstance.setValue(field.get(operationBase));
            }
        }
        catch (Exception exception) {}
    }
}

