/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.common.FileUtils;
import org.eclipse.emf.edapt.internal.common.StringUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.internal.ClassLoaderFacade;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigratorCommandLineOption;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.ui.LaunchUtils;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

class MigrationLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private Text historyText;
    private TableViewer modelViewer;
    private final List<String> modelURIs = new ArrayList<String>();
    private Button sourceReleaseCheck;
    private ComboViewer sourceReleaseCombo;
    private Button targetReleaseCheck;
    private ComboViewer targetReleaseCombo;
    private ComboViewer validationCombo;
    private Text vmArgsText;
    private Migrator migrator;
    private Button backupCheck;

    MigrationLaunchConfigurationMainTab() {
    }

    public void createControl(Composite parent) {
        Composite tabControl = new Composite(parent, 0);
        this.setControl((Control)tabControl);
        tabControl.setLayout((Layout)new GridLayout());
        this.createHistoryGroup(tabControl);
        this.createModelGroup(tabControl);
        this.createSourceReleaseGroup(tabControl);
        this.createTargetReleaseCombo(tabControl);
        this.createValidationGroup(tabControl);
        this.createBackupGroup(tabControl);
        this.createVMArgsGroup(tabControl);
    }

    private void createHistoryGroup(Composite parent) {
        Group historyGroup = this.createGroupControl(parent, MigratorCommandLineOption.HISTORY, 2);
        this.historyText = new Text((Composite)historyGroup, 2052);
        this.historyText.setLayoutData((Object)new GridData(768));
        this.historyText.addModifyListener((ModifyListener)new HistoryTextModifyListener());
        this.createPushButton((Composite)historyGroup, "Browse...", null).addSelectionListener((SelectionListener)new BrowseButtonListener());
    }

    private void createModelGroup(Composite parent) {
        Group modelGroup = this.createGroupControl(parent, MigratorCommandLineOption.MODELS, 2);
        this.modelViewer = new TableViewer((Composite)modelGroup, 2050);
        GridData data = new GridData(768);
        data.heightHint = 3 * this.modelViewer.getTable().getItemHeight();
        this.modelViewer.getTable().setLayoutData((Object)data);
        this.modelViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.modelViewer.setInput(this.modelURIs);
        Composite buttonComposite = new Composite((Composite)modelGroup, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        this.createPushButton(buttonComposite, "Add...", null).addSelectionListener((SelectionListener)new AddButtonListener());
        this.createPushButton(buttonComposite, "Remove", null).addSelectionListener((SelectionListener)new RemoveButtonListener());
    }

    private void createSourceReleaseGroup(Composite parent) {
        Group releaseGroup = this.createGroupControl(parent, MigratorCommandLineOption.SOURCE_RELEASE, 2);
        this.sourceReleaseCheck = this.createAutoButton((Composite)releaseGroup);
        this.sourceReleaseCombo = this.createReleaseCombo((Composite)releaseGroup);
        this.sourceReleaseCombo.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MigrationLaunchConfigurationMainTab.this.getSourceReleases().toArray();
            }
        });
        this.sourceReleaseCheck.addSelectionListener((SelectionListener)new ReleaseCheckListener(this.sourceReleaseCheck, this.sourceReleaseCombo));
    }

    private void createTargetReleaseCombo(Composite parent) {
        Group releaseGroup = this.createGroupControl(parent, MigratorCommandLineOption.TARGET_RELEASE, 2);
        this.targetReleaseCheck = this.createAutoButton((Composite)releaseGroup);
        this.targetReleaseCombo = this.createReleaseCombo((Composite)releaseGroup);
        this.targetReleaseCombo.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MigrationLaunchConfigurationMainTab.this.getTargetReleases().toArray();
            }
        });
        this.targetReleaseCheck.addSelectionListener((SelectionListener)new ReleaseCheckListener(this.targetReleaseCheck, this.targetReleaseCombo));
    }

    private Button createAutoButton(Composite parent) {
        return this.createCheckButton(parent, "Auto");
    }

    private ComboViewer createReleaseCombo(Composite composite) {
        ComboViewer releaseCombo = new ComboViewer(composite);
        releaseCombo.getCombo().setLayoutData((Object)new GridData(768));
        releaseCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Release release = (Release)element;
                String text = "Release " + release.getNumber();
                String label = release.getLabel();
                if (label != null && label.length() > 0) {
                    text = String.valueOf(text) + ": " + label;
                }
                return text;
            }
        });
        releaseCombo.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Release r1 = (Release)e1;
                Release r2 = (Release)e2;
                return r1.getNumber() - r2.getNumber();
            }
        });
        releaseCombo.addSelectionChangedListener((ISelectionChangedListener)new ComboListener());
        return releaseCombo;
    }

    private void createValidationGroup(Composite parent) {
        Group validationGroup = this.createGroupControl(parent, MigratorCommandLineOption.VALIDATION_LEVEL, 1);
        this.validationCombo = new ComboViewer((Composite)validationGroup);
        this.validationCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.validationCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.validationCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ValidationLevel level = (ValidationLevel)element;
                return StringUtils.upperCamelCaseToText((String)level.name());
            }
        });
        this.validationCombo.setInput((Object)ValidationLevel.values());
        this.validationCombo.addSelectionChangedListener((ISelectionChangedListener)new ComboListener());
    }

    private Set<Release> getSourceReleases() {
        this.initMigrator();
        if (this.migrator != null && !this.modelURIs.isEmpty()) {
            IFile file = FileUtils.getFile((String)this.modelURIs.get(0));
            URI modelURI = URIUtils.getURI((IResource)file);
            return this.migrator.getRelease(modelURI);
        }
        return Collections.emptySet();
    }

    private Collection<Release> getTargetReleases() {
        this.initMigrator();
        if (this.migrator != null) {
            return this.migrator.getReleases();
        }
        return Collections.emptySet();
    }

    private void initMigrator() {
        if (this.migrator == null) {
            try {
                IFile file = FileUtils.getFile((String)this.historyText.getText());
                URI historyURI = URIUtils.getURI((IResource)file);
                this.migrator = new Migrator(historyURI, (IClassLoader)new ClassLoaderFacade(Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception exception) {}
        }
    }

    public void createBackupGroup(Composite parent) {
        Group group = this.createGroupControl(parent, MigratorCommandLineOption.BACKUP, 1);
        this.backupCheck = this.createCheckButton((Composite)group, "Create a backup of the models before migration");
        this.backupCheck.addSelectionListener((SelectionListener)new CheckListener(null, null));
    }

    private void createVMArgsGroup(Composite parent) {
        this.vmArgsText = this.createMultiLineTextGroup(parent, MigratorCommandLineOption.VM_ARGUMENTS);
    }

    private Text createMultiLineTextGroup(Composite parent, MigratorCommandLineOption option) {
        Group group = this.createGroupControl(parent, option, 1);
        Text text = new Text((Composite)group, 2626);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 40).applyTo((Control)text);
        text.addModifyListener((ModifyListener)new TextModifyListener(null, null));
        return text;
    }

    private Group createGroupControl(Composite main, MigratorCommandLineOption option, int columns) {
        Group group = new Group(main, 0);
        group.setText(StringUtils.upperCamelCaseToText((String)option.name()));
        group.setLayout((Layout)new GridLayout(columns, false));
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.migrator = null;
        int sourceReleaseNumber = LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.SOURCE_RELEASE.id(), -1);
        this.sourceReleaseCheck.setSelection(sourceReleaseNumber == -1);
        int targetReleaseNumber = LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.TARGET_RELEASE.id(), -1);
        this.targetReleaseCheck.setSelection(targetReleaseNumber == -1);
        this.historyText.setText(LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.HISTORY.id(), ""));
        this.modelURIs.clear();
        this.modelURIs.addAll(LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.MODELS.id(), Collections.<String>emptyList()));
        this.modelViewer.refresh();
        this.initializeReleaseCombo(this.sourceReleaseCheck, this.sourceReleaseCombo, sourceReleaseNumber, MigratorCommandLineOption.SOURCE_RELEASE);
        this.initializeReleaseCombo(this.targetReleaseCheck, this.targetReleaseCombo, targetReleaseNumber, MigratorCommandLineOption.TARGET_RELEASE);
        String validation = LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.VALIDATION_LEVEL.id(), ValidationLevel.CUSTOM_MIGRATION.toString());
        this.validationCombo.setSelection((ISelection)new StructuredSelection((Object)ValidationLevel.valueOf((String)validation)));
        boolean backup = LaunchUtils.getAttribute(configuration, MigratorCommandLineOption.BACKUP.id(), false);
        this.backupCheck.setSelection(backup);
        this.vmArgsText.setText(LaunchUtils.getAttribute(configuration, IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""));
    }

    private void initializeReleaseCombo(Button check, ComboViewer combo, int releaseNumber, MigratorCommandLineOption option) {
        combo.getCombo().setEnabled(!check.getSelection());
        if (check.getSelection()) {
            combo.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            Collection<Release> releases;
            Release release;
            combo.setInput(new Object());
            if (releaseNumber >= 0 && (release = HistoryUtils.getRelease(releases = option == MigratorCommandLineOption.SOURCE_RELEASE ? this.getSourceReleases() : this.getTargetReleases(), (int)releaseNumber)) != null) {
                combo.setSelection((ISelection)new StructuredSelection((Object)release));
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String historyFilename = this.historyText.getText();
        configuration.setAttribute(MigratorCommandLineOption.HISTORY.id(), historyFilename);
        try {
            IFile file = FileUtils.getFile((String)historyFilename);
            if (file != null) {
                IProject project = file.getProject();
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        configuration.setAttribute(MigratorCommandLineOption.MODELS.id(), new ArrayList<String>(this.modelURIs));
        this.saveRelease(configuration, this.sourceReleaseCheck, this.sourceReleaseCombo, MigratorCommandLineOption.SOURCE_RELEASE);
        this.saveRelease(configuration, this.targetReleaseCheck, this.targetReleaseCombo, MigratorCommandLineOption.TARGET_RELEASE);
        ValidationLevel level = (ValidationLevel)SelectionUtils.getSelectedElement((ISelection)this.validationCombo.getSelection());
        configuration.setAttribute(MigratorCommandLineOption.VALIDATION_LEVEL.id(), level.toString());
        boolean backup = this.backupCheck.getSelection();
        configuration.setAttribute(MigratorCommandLineOption.BACKUP.id(), backup);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.vmArgsText.getText());
    }

    private void saveRelease(ILaunchConfigurationWorkingCopy configuration, Button check, ComboViewer combo, MigratorCommandLineOption option) {
        if (check.getSelection()) {
            configuration.setAttribute(option.id(), -1);
        } else {
            Release release = (Release)SelectionUtils.getSelectedElement((ISelection)combo.getSelection());
            if (release != null) {
                configuration.setAttribute(option.id(), release.getNumber());
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String historyFilename = this.historyText.getText();
        if (historyFilename.length() == 0) {
            this.setErrorMessage("History not specified");
            return false;
        }
        IFile historyFile = FileUtils.getFile((String)historyFilename);
        if (!historyFile.exists()) {
            this.setErrorMessage("History does not exist.");
            return false;
        }
        if (this.modelURIs.isEmpty()) {
            this.setErrorMessage("No model specified");
            return false;
        }
        for (String modelURI : this.modelURIs) {
            IFile modelFile = FileUtils.getFile((String)modelURI);
            if (modelFile.exists()) continue;
            this.setErrorMessage("Model does not exist.");
            return false;
        }
        if (!this.isValidRelease(this.sourceReleaseCheck, this.sourceReleaseCombo, MigratorCommandLineOption.SOURCE_RELEASE) || !this.isValidRelease(this.targetReleaseCheck, this.targetReleaseCombo, MigratorCommandLineOption.TARGET_RELEASE)) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isValidRelease(Button check, ComboViewer combo, MigratorCommandLineOption option) {
        if (!check.getSelection() && SelectionUtils.getSelectedElement((ISelection)combo.getSelection()) == null) {
            this.setErrorMessage(String.valueOf(StringUtils.upperCamelCaseToText((String)option.name())) + " must be set");
            return false;
        }
        return true;
    }

    private void refreshSourceReleaseCombo() {
        this.refreshReleaseCombo(this.sourceReleaseCheck, this.sourceReleaseCombo);
    }

    private void refreshTargetReleaseCombo() {
        this.refreshReleaseCombo(this.targetReleaseCheck, this.targetReleaseCombo);
    }

    private void refreshReleaseCombo(Button check, ComboViewer combo) {
        if (check.getSelection()) {
            combo.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            combo.setInput(new Object());
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] result;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(MigrationLaunchConfigurationMainTab.this.getShell(), false, (IContainer)workspaceRoot, 3);
            dialog.setInitialPattern("*.*");
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                IFile resource = (IFile)result[0];
                IPath path = resource.getFullPath();
                MigrationLaunchConfigurationMainTab.this.modelURIs.add(path.toString());
                MigrationLaunchConfigurationMainTab.this.modelViewer.refresh();
                if (MigrationLaunchConfigurationMainTab.this.modelURIs.size() == 1) {
                    MigrationLaunchConfigurationMainTab.this.refreshSourceReleaseCombo();
                }
                MigrationLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    private class BrowseButtonListener
    extends SelectionAdapter {
        private BrowseButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] result;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(MigrationLaunchConfigurationMainTab.this.getShell(), false, (IContainer)workspaceRoot, 3);
            dialog.setInitialPattern("*.history");
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                IFile resource = (IFile)result[0];
                IPath path = resource.getFullPath();
                MigrationLaunchConfigurationMainTab.this.historyText.setText(path.toString());
                MigrationLaunchConfigurationMainTab.this.migrator = null;
                MigrationLaunchConfigurationMainTab.this.refreshSourceReleaseCombo();
                MigrationLaunchConfigurationMainTab.this.refreshTargetReleaseCombo();
            }
        }
    }

    private class CheckListener
    extends SelectionAdapter {
        private CheckListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            MigrationLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }

        /* synthetic */ CheckListener(CheckListener checkListener, CheckListener checkListener2) {
            this();
        }
    }

    private class ComboListener
    implements ISelectionChangedListener {
        private ComboListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            MigrationLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class HistoryTextModifyListener
    extends TextModifyListener {
        private HistoryTextModifyListener() {
        }

        @Override
        public void modifyText(ModifyEvent e) {
            MigrationLaunchConfigurationMainTab.this.migrator = null;
            MigrationLaunchConfigurationMainTab.this.refreshSourceReleaseCombo();
            MigrationLaunchConfigurationMainTab.this.refreshTargetReleaseCombo();
            super.modifyText(e);
        }
    }

    private class ReleaseCheckListener
    extends CheckListener {
        private final Button releaseCheck;
        private final ComboViewer releaseCombo;

        public ReleaseCheckListener(Button releaseCheck, ComboViewer releaseCombo) {
            this.releaseCheck = releaseCheck;
            this.releaseCombo = releaseCombo;
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.releaseCombo.getCombo().setEnabled(!this.releaseCheck.getSelection());
            MigrationLaunchConfigurationMainTab.this.refreshReleaseCombo(this.releaseCheck, this.releaseCombo);
            super.widgetSelected(e);
        }
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            List elements = SelectionUtils.getSelectedElements((ISelection)MigrationLaunchConfigurationMainTab.this.modelViewer.getSelection());
            String modelURI = (String)MigrationLaunchConfigurationMainTab.this.modelURIs.get(0);
            MigrationLaunchConfigurationMainTab.this.modelURIs.removeAll(elements);
            MigrationLaunchConfigurationMainTab.this.modelViewer.refresh();
            if (elements.contains(modelURI)) {
                MigrationLaunchConfigurationMainTab.this.refreshSourceReleaseCombo();
            }
            MigrationLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MigrationLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }

        /* synthetic */ TextModifyListener(TextModifyListener textModifyListener, TextModifyListener textModifyListener2) {
            this();
        }
    }
}

