/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="newOppositeReference", label="Create Opposite Reference", description="In the metamodel, an opposite is created for a reference. In the model, the opposite direction needs to be set.")
public class NewOppositeReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference for which the opposite is created")
    public EReference reference;
    @EdaptParameter(description="The name of the opposite reference")
    public String name;
    @EdaptParameter(description="The lower bound of the opposite reference")
    public int lowerBound = 0;
    @EdaptParameter(description="The upper bound of the opposite reference")
    public int upperBound;
    @EdaptParameter(description="Whether the opposite reference is changeable")
    public Boolean changeable = true;

    @EdaptConstraint(restricts="reference", description="The reference must not already have an opposite")
    public boolean checkReference(EReference reference) {
        return reference.getEOpposite() == null;
    }

    @EdaptConstraint(description="In case of a containment reference, the upper bound of the opposite reference must be 1.")
    public boolean checkContainmentSingleValued() {
        return !this.reference.isContainment() || this.upperBound == 1;
    }

    @EdaptConstraint(description="In case of a cross reference, the upper bound of the opposite reference must be -1.")
    public boolean checkCrossReferenceManyValued() {
        return this.reference.isContainment() || this.upperBound == -1;
    }

    public void initialize(Metamodel metamodel) {
        this.upperBound = this.reference.isContainment() ? 1 : -1;
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass eClass = this.reference.getEReferenceType();
        EClass type = this.reference.getEContainingClass();
        EReference opposite = MetamodelFactory.newEReference((EClass)eClass, (String)this.name, (EClass)type, (int)this.lowerBound, (int)this.upperBound, (boolean)false);
        metamodel.setEOpposite(this.reference, opposite);
        opposite.setChangeable(this.changeable.booleanValue());
    }
}

