/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.cqddl.parser;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.TokenStream;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.cqddl.function.CQDDLEvaluationException;
import org.conqat.lib.cqddl.function.ICQDDLFunction;
import org.conqat.lib.cqddl.parser.CQDDLParseException;
import org.conqat.lib.cqddl.parser.CQDDLParsingParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CQDDLParserBase
extends Parser {
    private final Map<String, Object> storedObjects = new HashMap<String, Object>();
    private CQDDLParsingParameters parsingParameters = new CQDDLParsingParameters();
    private String errorMessage;

    protected CQDDLParserBase(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public void setParsingParameters(CQDDLParsingParameters parsingParameters) {
        this.parsingParameters = parsingParameters;
    }

    public void reportError(RecognitionException ex) {
        this.errorMessage = this.getErrorMessage(ex, this.getTokenNames());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void storeObject(String name, Object value) throws CQDDLParseException {
        if (this.storedObjects.containsKey(name)) {
            throw new CQDDLParseException("Duplicate stored object name: " + name);
        }
        this.storedObjects.put(name, value);
    }

    protected Object retrieveObject(String name) throws CQDDLParseException {
        if (!this.storedObjects.containsKey(name)) {
            throw new CQDDLParseException("Unknown object to retrieve: " + name);
        }
        return this.storedObjects.get(name);
    }

    protected String resolveKey(String key) {
        if (this.parsingParameters.keyAbbreviations.containsKey(key)) {
            return this.parsingParameters.keyAbbreviations.get(key);
        }
        return key;
    }

    protected Object eval(String functionName, PairList<String, Object> parameters) throws CQDDLParseException {
        ICQDDLFunction function = this.parsingParameters.functions.get(functionName);
        if (function == null) {
            throw new CQDDLParseException("No function of name " + functionName + " found!");
        }
        try {
            return function.eval(parameters);
        }
        catch (CQDDLEvaluationException e) {
            throw new CQDDLParseException("Error while evaluating function " + functionName, e);
        }
    }

    protected static String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }
}

