/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;

public abstract class SimpleControlRendererTester
implements ECPRendererTester {
    @Override
    public int isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        if (!VControl.class.isInstance(vElement)) {
            return -1;
        }
        VControl control = (VControl)vElement;
        EStructuralFeature.Setting setting = this.getSetting(control);
        if (setting == null) {
            return -1;
        }
        EStructuralFeature feature = setting.getEStructuralFeature();
        EObject eObject = setting.getEObject();
        if (this.isSingleValue() == feature.isMany()) {
            return -1;
        }
        if (EAttribute.class.isInstance(feature)) {
            if (this.checkAttributeInvalid((EAttribute)feature)) {
                return -1;
            }
        } else if (EReference.class.isInstance(feature)) {
            Class<EObject> instanceClass = feature.getEType().getInstanceClass();
            if (instanceClass == null) {
                instanceClass = EObject.class;
            }
            if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                return -1;
            }
        }
        if (this.getSupportedEObject().isInstance(eObject) && (this.getSupportedFeature() == null || feature.equals(this.getSupportedFeature()))) {
            return this.getPriority();
        }
        return -1;
    }

    private EStructuralFeature.Setting getSetting(VControl control) {
        Iterator iterator = control.getDomainModelReference().getIterator();
        int count = 0;
        EStructuralFeature.Setting setting = null;
        while (iterator.hasNext()) {
            ++count;
            setting = (EStructuralFeature.Setting)iterator.next();
        }
        if (count != 1) {
            return null;
        }
        return setting;
    }

    private boolean checkAttributeInvalid(EAttribute attribute) {
        block10: {
            Class instanceClass = attribute.getEAttributeType().getInstanceClass();
            if (instanceClass == null) {
                return true;
            }
            if (Object.class.equals(this.getSupportedClassType())) {
                return false;
            }
            if (instanceClass.isPrimitive()) {
                try {
                    Class primitive = (Class)this.getSupportedClassType().getField("TYPE").get(null);
                    if (!primitive.equals(instanceClass)) {
                        return true;
                    }
                    break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return true;
                }
                catch (SecurityException securityException) {
                    return true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return true;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return true;
                }
            }
            if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isSingleValue();

    protected abstract int getPriority();

    protected Class<? extends EObject> getSupportedEObject() {
        return EObject.class;
    }

    protected EStructuralFeature getSupportedFeature() {
        return null;
    }

    protected abstract Class<?> getSupportedClassType();
}

