/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.util.Collections;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIUpdateProjectController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIUpdateProjectToVersionController;
import org.eclipse.swt.widgets.Shell;

public final class UpdateProjectHelper {
    private UpdateProjectHelper() {
    }

    public static void update(InternalProject project, Shell shell) {
        ESLocalProject projectSpace = EMFStoreProvider.INSTANCE.getProjectSpace(project);
        if (projectSpace.getUsersession() == null) {
            ESServer serverInfo = EMFStoreProvider.INSTANCE.getServerInfo(project.getRepository());
            ((ProjectSpace)((ESLocalProjectImpl)projectSpace).toInternalAPI()).setUsersession((Usersession)((ESUsersessionImpl)serverInfo.getLastUsersession()).toInternalAPI());
        }
        new UIUpdateProjectController(shell, projectSpace).execute();
        project.notifyObjectsChanged(Collections.singleton(project), true);
    }

    public static void updateToVersion(InternalProject project, Shell shell) {
        ESLocalProject projectSpace = EMFStoreProvider.INSTANCE.getProjectSpace(project);
        if (projectSpace.getUsersession() == null) {
            ESServer serverInfo = EMFStoreProvider.INSTANCE.getServerInfo(project.getRepository());
            ((ProjectSpace)((ESLocalProjectImpl)projectSpace).toInternalAPI()).setUsersession((Usersession)((ESUsersessionImpl)serverInfo.getLastUsersession()).toInternalAPI());
        }
        new UIUpdateProjectToVersionController(shell, projectSpace).execute();
        project.notifyObjectsChanged(Collections.singleton(project), true);
    }
}

