/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.common.ui;

import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public final class TreeViewerFactory {
    private TreeViewerFactory() {
    }

    public static TreeViewer createTreeViewer(Composite parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, boolean sort) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        TreeViewerFactory.createTreeViewer(labelProvider, contentProvider, input, labelDecorator, viewer, sort);
        return viewer;
    }

    public static TreeViewer createCheckedTreeViewer(Composite parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, boolean sort) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent, 770);
        TreeViewerFactory.createTreeViewer(labelProvider, contentProvider, input, labelDecorator, (TreeViewer)viewer, sort);
        return viewer;
    }

    private static void createTreeViewer(ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, TreeViewer viewer, boolean sort) {
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (sort) {
            viewer.setSorter(new ViewerSorter());
        }
        viewer.setInput(input);
        if (labelDecorator != null && !(labelProvider instanceof DecoratingLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(labelProvider, labelDecorator));
        }
    }
}

