/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.stack.ui.swt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.internal.stack.ui.swt.Activator;
import org.eclipse.emf.ecp.view.internal.stack.ui.swt.messages.Messages;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackPackage;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SWTStackLayoutRenderer
extends AbstractSWTRenderer<VStackLayout> {
    private static final String CONTROL_STACK_COMPOSITE = "org_eclipse_emf_ecp_ui_layout_stack";
    private SWTGridDescription gridDescription;
    private ModelChangeListener listener;
    private Map<VStackItem, Composite> itemToCompositeMap;
    private StackLayout stackLayout;
    private Composite stackComposite;

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0) {
            return null;
        }
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setBackground(parent.getBackground());
        this.stackComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)CONTROL_STACK_COMPOSITE);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        LinkedHashMap<VStackItem, AbstractSWTRenderer> elementRendererMap = new LinkedHashMap<VStackItem, AbstractSWTRenderer>();
        for (VStackItem item : ((VStackLayout)this.getVElement()).getStackItems()) {
            AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer((VElement)item, this.getViewModelContext());
            if (renderer == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.stack.ui.swt", String.format(Messages.SWTStackLayoutRenderer_NoRendererForItemCompositeFound, item.eClass().getName())));
                continue;
            }
            elementRendererMap.put(item, renderer);
        }
        for (Map.Entry entry : elementRendererMap.entrySet()) {
            VStackItem stackItem = (VStackItem)entry.getKey();
            AbstractSWTRenderer renderer = (AbstractSWTRenderer)entry.getValue();
            Composite itemComposite = new Composite(this.stackComposite, 0);
            itemComposite.setBackground(parent.getBackground());
            SWTGridDescription elementGridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            itemComposite.setLayoutData(LayoutProviderHelper.getSpanningLayoutData((int)1, (int)1));
            itemComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)elementGridDescription.getColumns(), (boolean)false));
            for (SWTGridCell currentCell : elementGridDescription.getGrid()) {
                Control control = ((AbstractSWTRenderer)currentCell.getRenderer()).render(currentCell, itemComposite);
                if (control == null) continue;
                control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)currentCell, (SWTGridDescription)elementGridDescription, (SWTGridDescription)elementGridDescription, (SWTGridDescription)elementGridDescription, (VElement)((AbstractSWTRenderer)currentCell.getRenderer()).getVElement(), (Control)control));
            }
            for (SWTGridCell currentCell : elementGridDescription.getGrid()) {
                ((AbstractSWTRenderer)currentCell.getRenderer()).finalizeRendering(itemComposite);
            }
            this.itemToCompositeMap.put(stackItem, itemComposite);
        }
        Composite nullComposite = new Composite(this.stackComposite, 0);
        this.itemToCompositeMap.put(null, nullComposite);
        this.setTopElement();
        return this.stackComposite;
    }

    private void setTopElement() {
        VStackItem topElement = ((VStackLayout)this.getVElement()).getTopElement();
        Composite composite = this.itemToCompositeMap.get(topElement);
        if (composite == null) {
            return;
        }
        this.stackLayout.topControl = composite;
        this.stackComposite.layout();
    }

    protected void preInit() {
        super.preInit();
        this.listener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch()) {
                    return;
                }
                if (notification.getNotifier() != SWTStackLayoutRenderer.this.getVElement()) {
                    return;
                }
                if (notification.getStructuralFeature() == VStackPackage.eINSTANCE.getStackLayout_TopElement()) {
                    SWTStackLayoutRenderer.this.setTopElement();
                }
            }
        };
        this.itemToCompositeMap = new LinkedHashMap<VStackItem, Composite>();
    }

    protected void postInit() {
        super.postInit();
        this.setTopElement();
        this.getViewModelContext().registerViewChangeListener(this.listener);
    }

    protected void dispose() {
        this.getViewModelContext().unregisterViewChangeListener(this.listener);
        this.gridDescription = null;
        this.listener = null;
        this.itemToCompositeMap.clear();
        this.itemToCompositeMap = null;
        this.stackLayout = null;
        this.stackComposite = null;
        super.dispose();
    }
}

