/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.control.multireference;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.view.internal.control.multireference.Activator;
import org.eclipse.emf.ecp.view.internal.control.multireference.Messages;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MultiReferenceSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private Label validationIcon;
    private AdapterFactoryLabelProvider labelProvider;
    private ComposedAdapterFactory composedAdapterFactory;
    private TableViewer tableViewer;

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getRow() != 0 || cell.getColumn() != 0 || cell.getRenderer() != this) {
            throw new IllegalArgumentException("Wrong parameter passed!");
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackgroundMode(2);
        Iterator settings = ((VControl)this.getVElement()).getDomainModelReference().getIterator();
        if (!settings.hasNext()) {
            return null;
        }
        EStructuralFeature.Setting mainSetting = (EStructuralFeature.Setting)settings.next();
        this.createTitleComposite(composite, mainSetting);
        this.createLabelProvider();
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, 300).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        this.createContent(controlComposite, mainSetting);
        return composite;
    }

    private void createLabelProvider() {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        this.labelProvider.setFireLabelUpdateNotifications(true);
    }

    protected void dispose() {
        this.composedAdapterFactory.dispose();
        this.labelProvider.dispose();
        super.dispose();
    }

    private void createTitleComposite(Composite composite, final EStructuralFeature.Setting mainSetting) throws NoPropertyDescriptorFoundExeption {
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackgroundMode(2);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label filler = new Label(titleComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)filler);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Composite buttonComposite = new Composite(titleComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 4).applyTo((Control)buttonComposite);
        Button btnAddExisting = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnAddExisting);
        btnAddExisting.setImage(Activator.getImage("icons/link.png"));
        btnAddExisting.setToolTipText(Messages.MultiReferenceSWTRenderer_addExistingTooltip);
        btnAddExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                MultiReferenceSWTRenderer.this.handleAddExisting(MultiReferenceSWTRenderer.this.tableViewer, mainSetting);
            }
        });
        Button btnAddNew = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnAddNew);
        btnAddNew.setImage(Activator.getImage("icons/link_add.png"));
        btnAddNew.setToolTipText(Messages.MultiReferenceSWTRenderer_addNewTooltip);
        btnAddNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                MultiReferenceSWTRenderer.this.handleAddNew(MultiReferenceSWTRenderer.this.tableViewer, mainSetting);
            }
        });
        Button btnDelete = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnDelete);
        btnDelete.setImage(Activator.getImage("icons/delete.png"));
        btnDelete.setToolTipText(Messages.MultiReferenceSWTRenderer_deleteTooltip);
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                MultiReferenceSWTRenderer.this.handleDelete(MultiReferenceSWTRenderer.this.tableViewer, mainSetting);
            }
        });
    }

    private void createContent(Composite composite, EStructuralFeature.Setting mainSetting) {
        this.tableViewer = new TableViewer(composite, 68098);
        this.tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_multireference");
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)comparator);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EStructuralFeature eStructuralFeature = mainSetting.getEStructuralFeature();
        String text = eStructuralFeature.getName();
        String tooltipText = eStructuralFeature.getName();
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(mainSetting);
        if (itemPropertyDescriptor != null) {
            text = itemPropertyDescriptor.getDisplayName(null);
            tooltipText = itemPropertyDescriptor.getDescription(null);
        }
        TableViewerColumn column = TableViewerColumnBuilder.create().setText(text).setToolTipText(tooltipText).setResizable(false).setMoveable(false).setStyle(0).build(this.tableViewer);
        column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(this.tableViewer, comparator, column.getColumn(), 0));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(mainSetting), (EObject)mainSetting.getEObject(), (EStructuralFeature)mainSetting.getEStructuralFeature());
        this.tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, false));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EObject selectedObject = (EObject)((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).getFirstElement();
                MultiReferenceSWTRenderer.this.handleDoubleClick(selectedObject);
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    protected void handleDoubleClick(EObject selectedObject) {
        ReferenceService referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
        referenceService.openInNewContext(selectedObject);
    }

    protected void handleAddExisting(TableViewer tableViewer, EStructuralFeature.Setting setting) {
        ReferenceService referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
        referenceService.addExistingModelElements(setting.getEObject(), (EReference)setting.getEStructuralFeature());
        referenceService.openInNewContext(setting.getEObject());
    }

    protected void handleAddNew(TableViewer tableViewer, EStructuralFeature.Setting setting) {
        ReferenceService referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
        referenceService.addNewModelElements(setting.getEObject(), (EReference)setting.getEStructuralFeature());
    }

    protected void handleDelete(TableViewer tableViewer, EStructuralFeature.Setting mainSetting) {
        List deletionList = ((IStructuredSelection)IStructuredSelection.class.cast(tableViewer.getSelection())).toList();
        EObject modelElement = mainSetting.getEObject();
        EditingDomain editingDomain = this.getEditingDomain(mainSetting);
        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)mainSetting.getEStructuralFeature(), (Collection)deletionList));
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            EStructuralFeature feat1 = (EStructuralFeature)object1.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            EStructuralFeature feat2 = (EStructuralFeature)object2.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            Object value1 = object1.eGet(feat1);
            Object value2 = object2.eGet(feat2);
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }
}

