/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;

public final class EMFFormsSWTLayoutUtil {
    private EMFFormsSWTLayoutUtil() {
    }

    public static void adjustParentSize(Control control) {
        if (control.isDisposed()) {
            return;
        }
        Composite parent = control.getParent();
        while (parent != null) {
            ExpandBar bar;
            ExpandItem item;
            Control itemControl;
            if (ScrolledComposite.class.isInstance(parent)) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)ScrolledComposite.class.cast(parent);
                Control content = scrolledComposite.getContent();
                if (content == null) {
                    return;
                }
                Point point = content.computeSize(-1, -1);
                scrolledComposite.setMinSize(point);
            } else if (ExpandBar.class.isInstance(parent) && (itemControl = (item = (bar = (ExpandBar)ExpandBar.class.cast(parent)).getItem(0)).getControl()) != null) {
                int oldHeight = item.getHeight();
                int height = itemControl.computeSize((int)bar.getSize().x, (int)-1, (boolean)true).y;
                EMFFormsSWTLayoutUtil.updateLayoutData(bar.getLayoutData(), oldHeight, height);
                item.setHeight(height);
            }
            if (parent.getParent() == null) {
                parent.layout(true, true);
            }
            if (Shell.class.isInstance(parent)) {
                parent.layout(true, true);
            }
            parent = parent.getParent();
        }
    }

    private static void updateLayoutData(Object layoutData, int oldHeight, int newHeight) {
        if (layoutData instanceof GridData) {
            int heightHint;
            GridData gridData = (GridData)layoutData;
            if (gridData.heightHint == -1) {
                return;
            }
            gridData.heightHint = heightHint = gridData.heightHint - oldHeight + newHeight;
        }
    }
}

