/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.controls;

import javax.inject.Inject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class TypedElementBoundsRenderer
extends AbstractControlSWTRenderer<VControl> {
    private SWTGridDescription rendererGridDescription;

    @Inject
    public TypedElementBoundsRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    public final SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE ? 2 : 3, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected final Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createBoundsLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                return this.createControl(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", gridCell.toString(), ((Object)((Object)this)).toString()));
    }

    private Control createBoundsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
        label.setText("Bounds");
        return label;
    }

    private Control createControl(Composite parent) {
        final ETypedElement domainObject = (ETypedElement)this.getViewModelContext().getDomainModel();
        final EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)domainObject);
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        final Spinner lowerBound = new Spinner(main, 2048);
        lowerBound.setLayoutData((Object)new GridData(4, -1, true, true));
        lowerBound.setSelection(domainObject.getLowerBound());
        lowerBound.setMaximum(Integer.MAX_VALUE);
        final Spinner upperBound = new Spinner(main, 2048);
        upperBound.setLayoutData((Object)new GridData(4, -1, true, true));
        upperBound.setMinimum(-1);
        upperBound.setSelection(domainObject.getUpperBound());
        upperBound.setEnabled(domainObject.getUpperBound() != -1);
        upperBound.setMaximum(Integer.MAX_VALUE);
        final Button unbounded = new Button(main, 32);
        unbounded.setText("unbounded");
        unbounded.setSelection(false);
        unbounded.setSelection(domainObject.getUpperBound() == -1);
        lowerBound.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ((Spinner)e.getSource()).getSelection();
                editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__LOWER_BOUND, (Object)i));
                if (upperBound.getSelection() < i && upperBound.getSelection() >= 0) {
                    upperBound.setSelection(i);
                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, (Object)i));
                }
                TypedElementBoundsRenderer.this.applyValidation();
            }
        });
        upperBound.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ((Spinner)e.getSource()).getSelection();
                editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, (Object)i));
                if (lowerBound.getSelection() > i && i >= 0) {
                    lowerBound.setSelection(i);
                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__LOWER_BOUND, (Object)i));
                }
                unbounded.setSelection(i == -1);
                TypedElementBoundsRenderer.this.applyValidation();
            }
        });
        unbounded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (unbounded.getSelection()) {
                    upperBound.setSelection(-1);
                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, (Object)-1));
                } else {
                    upperBound.setSelection(lowerBound.getSelection());
                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)domainObject, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, (Object)lowerBound.getSelection()));
                }
                upperBound.setEnabled(!unbounded.getSelection());
                TypedElementBoundsRenderer.this.applyValidation();
            }
        });
        this.applyValidation();
        return main;
    }

    private void setValidationColor(Control control, Color validationColor) {
        control.setBackground(validationColor);
    }

    protected final void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TypedElementBoundsRenderer.this.applyInnerValidation();
            }
        });
    }

    private void applyInnerValidation() {
        Control editControl;
        Label validationIcon;
        switch (this.getControls().size()) {
            case 2: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 0, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this));
                break;
            }
            case 3: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 2, (AbstractSWTRenderer)this));
                break;
            }
            default: {
                return;
            }
        }
        if (validationIcon == null || editControl == null) {
            return;
        }
        if (validationIcon.isDisposed()) {
            return;
        }
        if (((VControl)this.getVElement()).getDiagnostic() == null) {
            return;
        }
        validationIcon.setImage(this.getValidationIcon(((VControl)this.getVElement()).getDiagnostic().getHighestSeverity()));
        validationIcon.setToolTipText(((VControl)this.getVElement()).getDiagnostic().getMessage());
        this.setValidationColor(editControl, this.getValidationBackgroundColor(((VControl)this.getVElement()).getDiagnostic().getHighestSeverity()));
    }
}

