/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.controls;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emfforms.internal.editor.ecore.controls.TextRenderer;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="TextRendererService")
public class TextRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        if (!TextRendererService.checkLoadingProperties(control)) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)EStructuralFeature.class.cast(valueProperty.getValueType());
        if (eStructuralFeature.isMany()) {
            return Double.NaN;
        }
        if (!EAttribute.class.isInstance(eStructuralFeature)) {
            return Double.NaN;
        }
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
        if (instanceClass == null) {
            return Double.NaN;
        }
        if (String.class.isAssignableFrom(instanceClass)) {
            return 2.0;
        }
        return Double.NaN;
    }

    private static boolean checkLoadingProperties(VControl control) {
        EObject viewCandidate = control.eContainer();
        while (viewCandidate != null && !VView.class.isInstance(viewCandidate)) {
            viewCandidate = viewCandidate.eContainer();
        }
        if (!VView.class.isInstance(viewCandidate)) {
            return false;
        }
        VViewModelProperties properties = ((VView)VView.class.cast(viewCandidate)).getLoadingProperties();
        if (properties == null) {
            return false;
        }
        return "true".equalsIgnoreCase((String)properties.get("useOnModifyDatabinding"));
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return TextRenderer.class;
    }
}

