/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NumberControlSWTRenderer
extends TextControlSWTRenderer {
    private final EMFFormsLocalizationService localizationService;
    private final EMFFormsLocaleProvider localeProvider;
    private EMFFormsLocaleChangeListener emfFormsLocaleChangeListener;

    @Inject
    public NumberControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.localizationService = localizationService;
        this.localeProvider = localeProvider;
    }

    @Override
    protected int getDefaultAlignment() {
        return 131072;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getTextMessage() {
        try {
            IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
            EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
            return NumericalHelper.setupFormat((Locale)this.localeProvider.getLocale(), this.getInstanceClass(structuralFeature)).toPattern();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return "";
        }
    }

    @Override
    protected Binding[] createBindings(final Control control) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        NumericalTargetToModelUpdateStrategy targetToModelStrategy = new NumericalTargetToModelUpdateStrategy(structuralFeature, this.getViewModelContext(), this.getModelValue(), this.getDataBindingContext(), (Text)control);
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(structuralFeature), this.getViewModelContext(), false);
        final Binding binding = this.bindValue(control, this.getModelValue(), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(structuralFeature), this.getViewModelContext(), true));
        this.emfFormsLocaleChangeListener = new EMFFormsLocaleChangeListener(){

            public void notifyLocaleChange() {
                ((Text)control).setMessage(NumberControlSWTRenderer.this.getTextMessage());
                binding.updateModelToTarget();
            }
        };
        this.localeProvider.addEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        return new Binding[]{binding, tooltipBinding};
    }

    private Class<?> getInstanceClass(EStructuralFeature feature) {
        return feature.getEType().getInstanceClass();
    }

    @Override
    protected String getUnsetText() {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_NoNumberClickToSetNumber");
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.localeProvider.removeEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
    }

    private class NumericalModelToTargetUpdateStrategy
    extends TextControlSWTRenderer.ModelToTargetUpdateStrategy {
        private final Class<?> instanceClass;
        private final ViewModelContext viewModelContext;

        public NumericalModelToTargetUpdateStrategy(Class<?> instanceClass, ViewModelContext viewModelContext, boolean tooltip) {
            super(tooltip);
            this.instanceClass = instanceClass;
            this.viewModelContext = viewModelContext;
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return "";
            }
            DecimalFormat format = NumericalHelper.setupFormat((Locale)NumberControlSWTRenderer.this.localeProvider.getLocale(), this.instanceClass);
            return format.format(value);
        }
    }

    private class NumericalTargetToModelUpdateStrategy
    extends TextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final ViewModelContext viewModelContext;
        private final Text text;
        private final IObservableValue modelValue;
        private final EStructuralFeature eStructuralFeature;
        private final DataBindingContext dataBindingContext;

        public NumericalTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext, IObservableValue modelValue, DataBindingContext dataBindingContext, Text text) {
            super(eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.viewModelContext = viewModelContext;
            this.modelValue = modelValue;
            this.dataBindingContext = dataBindingContext;
            this.text = text;
        }

        private DecimalFormat getFormat() {
            return NumericalHelper.setupFormat((Locale)NumberControlSWTRenderer.this.localeProvider.getLocale(), (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
        }

        @Override
        protected Object convertValue(Object value) {
            String formatedNumber;
            DecimalFormat format;
            block28: {
                format = this.getFormat();
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalHelper.getDefaultValue((Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalHelper.isInteger((Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature))) {
                            boolean maxValue = false;
                            boolean minValue = false;
                            Class instanceClass = NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature);
                            String formatedValue = "";
                            try {
                                if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (number.doubleValue() >= 2.147483647E9) {
                                        maxValue = true;
                                        formatedValue = format.format(Integer.MAX_VALUE);
                                    } else if (number.doubleValue() <= -2.147483648E9) {
                                        minValue = true;
                                        formatedValue = format.format(Integer.MIN_VALUE);
                                    }
                                } else if (Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (number.doubleValue() >= 9.223372036854776E18) {
                                        maxValue = true;
                                        formatedValue = format.format(Long.MAX_VALUE);
                                    } else if (number.doubleValue() <= -9.223372036854776E18) {
                                        minValue = true;
                                        formatedValue = format.format(Long.MIN_VALUE);
                                    }
                                } else if (Short.class.isAssignableFrom(instanceClass) || Short.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (number.doubleValue() >= 32767.0) {
                                        maxValue = true;
                                        formatedValue = format.format(32767L);
                                    } else if (number.doubleValue() <= -32768.0) {
                                        minValue = true;
                                        formatedValue = format.format(-32768L);
                                    }
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                Activator.logException(ex);
                            }
                            catch (SecurityException ex) {
                                Activator.logException(ex);
                            }
                            catch (IllegalAccessException ex) {
                                Activator.logException(ex);
                            }
                            catch (NoSuchFieldException ex) {
                                Activator.logException(ex);
                            }
                            if (maxValue || minValue) {
                                this.text.setText(formatedValue);
                                return NumericalHelper.numberToInstanceClass((Number)number, (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = format.format(number);
                    }
                    this.text.setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block28;
                    return null;
                }
                catch (ParseException parseException) {
                    return this.revertToOldValue(value);
                }
            }
            return NumericalHelper.numberToInstanceClass((Number)format.parse(formatedNumber), (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
        }

        private Object revertToOldValue(Object value) {
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = this.modelValue.getValue();
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), NumberControlSWTRenderer.this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_InvalidNumber"), null, NumberControlSWTRenderer.this.localizationService.getString(((Object)((Object)this)).getClass(), "NumericalControl_InvalidNumberWillBeUnset"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            this.dataBindingContext.updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

