/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class DerivedAttributeAdapter
extends AdapterImpl {
    private final Set<EStructuralFeature> localFeatures = new LinkedHashSet<EStructuralFeature>();
    private final InternalEObject source;
    private final EStructuralFeature derivedFeature;
    private Object oldValue;

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature) {
        this.source = (InternalEObject)source;
        this.derivedFeature = derivedFeature;
        this.oldValue = derivedFeature.getDefaultValue();
        source.eAdapters().add((Object)this);
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        this.localFeatures.add(localFeature);
    }

    public void addNavigatedDependency(EStructuralFeature dependentFeature, EReference ... navigationFeatures) {
        if (navigationFeatures.length < 1) {
            throw new IllegalArgumentException("Use addLocalDependency instead.");
        }
        new NavigationAdapter(this.source, navigationFeatures, dependentFeature);
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object feature = notification.getFeature();
        if (feature == null) {
            return;
        }
        if (this.localFeatures.contains(feature)) {
            this.notifyDerivedAttributeChange();
        }
    }

    private void notifyDerivedAttributeChange() {
        if (!this.source.eNotificationRequired()) {
            return;
        }
        boolean eIsSet = this.source.eIsSet(this.derivedFeature);
        Object newValue = this.source.eGet(this.derivedFeature, true, true);
        int eventType = eIsSet ? 1 : 2;
        this.source.eNotify((Notification)new ENotificationImpl(this.source, eventType, this.derivedFeature, this.oldValue, newValue));
        this.oldValue = newValue;
    }

    class NavigationAdapter
    extends AdapterImpl {
        private boolean hasChildren;
        private EStructuralFeature ownFeature;
        private final Map<EObject, NavigationAdapter> children = new LinkedHashMap<EObject, NavigationAdapter>();
        private EReference[] remainingPath;
        private EStructuralFeature dependentFeature;
        private final InternalEObject source;

        NavigationAdapter(InternalEObject source, EReference[] navigationFeatures, EStructuralFeature dependentFeature) {
            this.source = source;
            if (navigationFeatures.length != 0) {
                this.hasChildren = true;
                this.ownFeature = navigationFeatures[0];
                this.remainingPath = Arrays.copyOfRange(navigationFeatures, 1, navigationFeatures.length);
                this.dependentFeature = dependentFeature;
                if (this.ownFeature.isMany()) {
                    List list = (List)source.eGet(this.ownFeature);
                    for (InternalEObject child : list) {
                        if (child == null) continue;
                        this.addNavigationAdapter(dependentFeature, this.remainingPath, child);
                    }
                } else {
                    InternalEObject child = (InternalEObject)source.eGet(this.ownFeature);
                    if (child != null) {
                        this.addNavigationAdapter(dependentFeature, this.remainingPath, child);
                    }
                }
            } else {
                this.hasChildren = false;
                this.ownFeature = dependentFeature;
            }
            source.eAdapters().add((Object)this);
        }

        private void addNavigationAdapter(EStructuralFeature dependentFeature, EReference[] remainingPath, InternalEObject child) {
            this.children.put((EObject)child, new NavigationAdapter(child, remainingPath, dependentFeature));
        }

        Map<EObject, NavigationAdapter> children() {
            return this.children;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if (feature == null) {
                return;
            }
            if (this.ownFeature != feature) {
                return;
            }
            if (this.hasChildren) {
                switch (notification.getEventType()) {
                    case 3: {
                        InternalEObject added = (InternalEObject)notification.getNewValue();
                        this.addNavigationAdapter(this.dependentFeature, this.remainingPath, added);
                        break;
                    }
                    case 5: {
                        List allAdded = (List)notification.getNewValue();
                        for (InternalEObject addedObject : allAdded) {
                            this.addNavigationAdapter(this.dependentFeature, this.remainingPath, addedObject);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        InternalEObject newValue = (InternalEObject)notification.getNewValue();
                        InternalEObject oldValue = (InternalEObject)notification.getOldValue();
                        if (oldValue != null) {
                            this.children.remove(oldValue).dispose();
                        }
                        if (newValue == null) break;
                        this.addNavigationAdapter(this.dependentFeature, this.remainingPath, newValue);
                        break;
                    }
                    case 4: {
                        InternalEObject removed = (InternalEObject)notification.getOldValue();
                        this.children.remove(removed).dispose();
                        break;
                    }
                    case 6: {
                        List listRemoved = (List)notification.getOldValue();
                        for (InternalEObject removedObj : listRemoved) {
                            this.children.remove(removedObj).dispose();
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            DerivedAttributeAdapter.this.notifyDerivedAttributeChange();
        }

        private void dispose() {
            for (NavigationAdapter navigationAdapter : this.children.values()) {
                navigationAdapter.dispose();
            }
            this.source.eAdapters().remove((Object)this);
        }
    }
}

