/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.dialogs;

import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.composites.PropertiesComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertiesDialog
extends TitleAreaDialog {
    private final String title;
    private final String message;
    private final boolean editable;
    private final ECPProperties properties;

    public PropertiesDialog(Shell parentShell, String title, String message, boolean editable, ECPProperties properties) {
        super(parentShell);
        this.setShellStyle(65584);
        this.title = title;
        this.message = message;
        this.editable = editable;
        this.properties = properties;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final ECPProperties getProperties() {
        return this.properties;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PropertiesDialog_DialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setTitleImage(Activator.getImage("icons/properties_wiz.png"));
        this.setMessage(this.message);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite specialProperties = new Composite(container, 0);
        specialProperties.setLayout((Layout)new FillLayout(256));
        specialProperties.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.createSpecialProperties(specialProperties);
        PropertiesComposite propertiesComposite = new PropertiesComposite(container, this.editable, this.properties);
        propertiesComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        if (!this.editable) {
            propertiesComposite.setFocus();
        }
        return area;
    }

    protected void createSpecialProperties(Composite parent) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceResources.getString((String)"ok"), true);
        if (this.editable) {
            this.createButton(parent, 1, JFaceResources.getString((String)"cancel"), false);
        }
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    protected Text addTextProperty(Composite composite, String key, String value) {
        Label label = new Label(composite, 0);
        label.setText(key == null ? "" : key);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Text text = new Text(composite, 0);
        text.setText(value == null ? "" : value);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        text.setEditable(this.isEditable());
        return text;
    }
}

