/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.history.reconstruction.CompositeReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.FinishedException;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.InitializerChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.ValueChange;

public abstract class ForwardReconstructorBase
extends CompositeReconstructorBase {
    private EObject target;
    private boolean before;

    @Override
    protected void doReconstruct(EObject target, History originalHistory, boolean before) {
        this.mapping = new Mapping();
        this.extent = new MetamodelExtent();
        this.init(this.mapping, this.extent);
        this.target = target;
        this.before = before;
        this.startHistory(originalHistory);
        try {
            for (Release release : originalHistory.getReleases()) {
                this.doReconstruct(release);
            }
        }
        catch (FinishedException finishedException) {
            // empty catch block
        }
        this.endHistory(originalHistory);
    }

    private void doReconstruct(Release originalRelease) {
        if (this.before && originalRelease == this.target) {
            throw new FinishedException();
        }
        this.startRelease(originalRelease);
        for (Change change : originalRelease.getChanges()) {
            this.doReconstruct(change);
        }
        this.endRelease(originalRelease);
        if (!this.before && originalRelease == this.target) {
            throw new FinishedException();
        }
    }

    private void doReconstruct(Change originalChange) {
        if (this.before && originalChange == this.target) {
            throw new FinishedException();
        }
        this.startChange(originalChange);
        if (originalChange instanceof CompositeChange) {
            CompositeChange compositeChange = (CompositeChange)originalChange;
            for (Change change : compositeChange.getChanges()) {
                this.doReconstruct(change);
            }
        } else if (originalChange instanceof MigrationChange) {
            MigrationChange migrationChange = (MigrationChange)originalChange;
            for (Change change : migrationChange.getChanges()) {
                this.doReconstruct(change);
            }
        } else if (originalChange instanceof InitializerChange) {
            InitializerChange createChild = (InitializerChange)originalChange;
            for (ValueChange change : createChild.getChanges()) {
                this.doReconstruct(change);
            }
        }
        this.endChange(originalChange);
        if (!this.before && originalChange == this.target) {
            throw new FinishedException();
        }
    }
}

