/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.ide.editor.view.Activator;
import org.eclipse.emf.ecp.ide.editor.view.MigrationDialogHelper;
import org.eclipse.emf.ecp.ide.editor.view.messages.Messages;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.ide.spi.util.ViewModelHelper;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigrationException;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigratorUtil;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelWorkspaceMigrator;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.DefaultReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrationException;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.migrator.ViewModelWorkspaceMigrator;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.services.ECPSelectionProviderService;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ViewEditorPart
extends EditorPart
implements ViewModelEditorCallback,
IEditingDomainProvider {
    private Resource resource;
    private BasicCommandStack basicCommandStack;
    private Composite parent;
    private ECPSWTView render;
    private boolean ecoreOutOfSync;
    private IPartListener2 partListener;
    private final ViewEditorPart instance = this;
    private AdapterFactoryEditingDomain editingDomain;

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    ViewEditorPart.this.resource.save(ViewEditorPart.this.getSaveOptions());
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            this.basicCommandStack.saveIsDone();
            this.firePropertyChange(257);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    protected Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("ENCODING", "UTF-8");
        return options;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        super.setPartName(input.getName());
        try {
            this.basicCommandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)this.basicCommandStack);
            this.editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.loadView(false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.registerEcore(this.resource);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
            throw new PartInitException(MessageFormat.format(Messages.ViewEditorPart_ViewCannotBeDisplayed, e.getLocalizedMessage()), (Throwable)e);
        }
        try {
            this.loadView(true, true);
            this.checkLoadedView();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
            throw new PartInitException(MessageFormat.format(Messages.ViewEditorPart_ViewCannotBeDisplayed, e.getLocalizedMessage()), (Throwable)e);
        }
        this.basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ViewEditorPart.this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViewEditorPart.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.partListener = new ViewPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        EditorResourceChangedListener listener = new EditorResourceChangedListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ViewModelContext.class) {
            return adapter.cast(this.render.getViewModelContext());
        }
        return (T)super.getAdapter(adapter);
    }

    private void checkLoadedView() throws IllegalArgumentException, IllegalStateException {
        if (this.getView() == null) {
            throw new IllegalArgumentException(Messages.ViewEditorPart_InvalidVView);
        }
        EClass rootEClass = this.getView().getRootEClass();
        if (rootEClass == null) {
            throw new IllegalArgumentException(Messages.ViewEditorPart_invalidVView_noRootEClass);
        }
        if (rootEClass.eIsProxy()) {
            String proxyUri = EcoreUtil.getURI((EObject)rootEClass).toString();
            String packageNsUri = proxyUri.split("#")[0];
            String rootEClassName = proxyUri.split("#")[1].substring(2);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageNsUri);
            if (ePackage == null || ePackage.eIsProxy()) {
                throw new IllegalStateException(MessageFormat.format(Messages.ViewEditorPart_invalidVView_rootEClassPackageNotResolved, rootEClassName, packageNsUri));
            }
            throw new IllegalStateException(MessageFormat.format(Messages.ViewEditorPart_invalidVView_rootEClassNotInPackage, rootEClassName, ePackage.getName(), ePackage.getNsURI()));
        }
    }

    public boolean isDirty() {
        return this.basicCommandStack.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void loadView(boolean migrate, boolean resolve) throws IOException, PartInitException {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput(), (URIConverter)this.editingDomain.getResourceSet().getURIConverter());
        if (migrate) {
            this.checkMigration(resourceURI);
        }
        this.editingDomain.getResourceSet().getResources().clear();
        this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        if (this.resource.getContents().size() == 0 || !VView.class.isInstance(this.resource.getContents().get(0))) {
            throw new PartInitException(Messages.ViewEditorPart_InvalidVView);
        }
        if (resolve) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            int rsSize = resourceSet.getResources().size();
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            while (rsSize != resourceSet.getResources().size()) {
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                rsSize = resourceSet.getResources().size();
            }
        }
    }

    private void checkMigration(URI resourceURI) {
        final ViewModelMigrator migrator = ViewModelMigratorUtil.getViewModelMigrator();
        if (migrator == null) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        boolean needsMigration = this.checkIfMigrationIsNeeded(shell, resourceURI, migrator);
        if (needsMigration) {
            boolean migrate = MessageDialog.openQuestion((Shell)shell, (String)Messages.ViewEditorPart_MigrationTitle, (String)Messages.ViewEditorPart_MigrationQuestion);
            if (migrate) {
                boolean migrateWorkspace = MessageDialog.openQuestion((Shell)shell, (String)Messages.WorkspaceMigrationDialog_Title, (String)Messages.WorkspaceMigrationDialog_Description);
                final ArrayList<URI> toMigrate = new ArrayList<URI>();
                if (migrateWorkspace) {
                    for (URI uri : this.getWorkspaceURIsToMigrate(resourceURI)) {
                        try {
                            Resource workspaceResource = this.editingDomain.getResourceSet().getResource(uri, true);
                            this.registerEcore(workspaceResource);
                            toMigrate.add(uri);
                        }
                        catch (Exception ex) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", MessageFormat.format(Messages.ViewEditorPart_WorkspaceMigrationError, uri.toString()), (Throwable)ex));
                        }
                    }
                }
                toMigrate.add(resourceURI);
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            for (URI uri : toMigrate) {
                                migrator.performMigration(uri);
                            }
                        }
                        catch (ViewModelMigrationException ex) {
                            throw new InvocationTargetException(ex);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(shell).run(true, false, runnable);
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_MigrationErrorTitle, (String)(String.valueOf(Messages.ViewEditorPart_MigrationErrorText1) + Messages.ViewEditorPart_MigrationErrorText2));
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)e));
                }
                catch (InterruptedException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_MigrationErrorTitle, (String)(String.valueOf(Messages.ViewEditorPart_MigrationErrorText1) + Messages.ViewEditorPart_MigrationErrorText2));
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)e));
                }
            }
            this.migrateTemplateModels(shell);
        }
    }

    private void migrateTemplateModels(Shell shell) {
        final TemplateModelWorkspaceMigrator templateMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (templateMigrator == null) {
            return;
        }
        boolean migrateTemplates = MessageDialog.openQuestion((Shell)shell, (String)Messages.ViewEditorPart_TemplateMigrationTitle, (String)Messages.ViewEditorPart_TemplateMigrationDescription);
        if (migrateTemplates) {
            final List<URI> templateModelsToMigrate = this.getTemplateModelWorkspaceURIsToMigrate();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        for (URI uri : templateModelsToMigrate) {
                            templateMigrator.performMigration(uri);
                        }
                    }
                    catch (TemplateModelMigrationException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_TemplateMigrationErrorTitle, (String)Messages.ViewEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
            catch (InterruptedException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_TemplateMigrationErrorTitle, (String)Messages.ViewEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
        }
    }

    private List<URI> getWorkspaceURIsToMigrate(URI resourceURI) {
        ArrayList<URI> uris = new ArrayList<URI>();
        ViewModelWorkspaceMigrator workspaceMigrator = ViewModelMigratorUtil.getViewModelWorkspaceMigrator();
        if (workspaceMigrator == null) {
            return uris;
        }
        try {
            Object[] selectedURIs;
            Shell shell;
            ListSelectionDialog migrationDialog;
            ArrayList urIsToMigrate = workspaceMigrator.getURIsToMigrate();
            IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(resourceURI.toPlatformString(true));
            String osString = findMember.getLocation().toOSString();
            urIsToMigrate.remove(URI.createFileURI((String)osString));
            if (urIsToMigrate.size() > 0 && (migrationDialog = MigrationDialogHelper.getViewModelListMigrationDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), urIsToMigrate)).open() == 0 && (selectedURIs = migrationDialog.getResult()) != null) {
                Object[] objectArray = selectedURIs;
                int n = selectedURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedUri = objectArray[n2];
                    uris.add((URI)selectedUri);
                    ++n2;
                }
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", ex.getMessage(), (Throwable)ex));
        }
        return uris;
    }

    private List<URI> getTemplateModelWorkspaceURIsToMigrate() {
        LinkedList<URI> uris = new LinkedList<URI>();
        TemplateModelWorkspaceMigrator workspaceMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (workspaceMigrator == null) {
            return uris;
        }
        try {
            Object[] selectedURIs;
            Shell shell;
            ListSelectionDialog migrationDialog;
            List urIsToMigrate = workspaceMigrator.getURIsToMigrate();
            if (urIsToMigrate.size() > 0 && (migrationDialog = MigrationDialogHelper.getTemplateModelListMigrationDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), urIsToMigrate)).open() == 0 && (selectedURIs = migrationDialog.getResult()) != null) {
                Object[] objectArray = selectedURIs;
                int n = selectedURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedUri = objectArray[n2];
                    uris.add((URI)selectedUri);
                    ++n2;
                }
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", ex.getMessage(), (Throwable)ex));
        }
        return uris;
    }

    private boolean checkIfMigrationIsNeeded(Shell shell, URI resourceURI, ViewModelMigrator migrator) {
        CheckMigrationRunnable runnable = new CheckMigrationRunnable(migrator, resourceURI);
        try {
            new ProgressMonitorDialog(shell).run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)ex));
        }
        catch (InterruptedException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)ex));
        }
        return runnable.getResult();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        VView view = this.getView();
        Activator.getViewModelRegistry().registerViewModel(view, this.resource.getURI().toString());
        try {
            Activator.getViewModelRegistry().registerViewModelEditor(view, (ViewModelEditorCallback)this);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
        if (view.getRootEClass() != null) {
            if (view.getRootEClass().eResource() != null) {
                Activator.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.ide.editor.view", "The Root EClass of the view cannot be resolved." + view.getRootEClass()));
            }
        }
        this.showView();
    }

    private void registerEcore(Resource viewResource) throws IOException {
        for (String ecorePath : ViewModelHelper.getEcorePaths((Resource)viewResource)) {
            if (ecorePath == null) {
                return;
            }
            EcoreHelper.registerEcore((String)ecorePath);
        }
    }

    private void saveChangedView(VView view) {
        try {
            view.eResource().save(this.getSaveOptions());
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    private String selectEcoreFromWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getType() == 1) {
                    return new Status(0, "org.eclipse.emf.ecp.ide.editor.view", 0, null, null);
                }
                return new Status(4, "org.eclipse.emf.ecp.ide.editor.view", 4, Messages.ViewEditorPart_EcoreSelectionValidation, null);
            }
        });
        dialog.setTitle(Messages.ViewEditorPart_EcoreSelectionTitle);
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return file.getFullPath().toString();
        }
        return null;
    }

    private void showView() {
        VView view = this.getView();
        if (XMLResource.class.isInstance(view.eResource()) && !((XMLResource)XMLResource.class.cast(view.eResource())).getEObjectToExtensionMap().isEmpty()) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.ViewEditorPart_LoadedPartlyTitle, (String)Messages.ViewEditorPart_LoadedPartlyDescription);
        }
        try {
            ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)ViewProviderHelper.getView((EObject)view, null), (EObject)view, new ViewModelService[]{new DefaultReferenceService(), new EMFDeleteServiceImpl()});
            viewModelContext.putContextValue("enableMultiEdit", (Object)Boolean.TRUE);
            this.render = ECPSWTViewRenderer.INSTANCE.render(this.parent, viewModelContext);
            this.getSite().setSelectionProvider(((ECPSelectionProviderService)viewModelContext.getService(ECPSelectionProviderService.class)).getSelectionProvider());
        }
        catch (ECPRendererException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emf.ecp.ide.editor.view", ex.getMessage(), (Throwable)ex)));
        }
    }

    public void setFocus() {
    }

    public void reloadViewModel() {
        Display.getDefault().asyncExec((Runnable)new ReloadViewModelRunnable());
    }

    public void dispose() {
        VView view = this.getView();
        if (view != null) {
            Activator.getViewModelRegistry().unregisterViewModelEditor(view, (ViewModelEditorCallback)this);
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        super.dispose();
    }

    public VView getView() {
        if (this.resource == null || this.resource.getContents().isEmpty()) {
            return null;
        }
        EObject eObject = (EObject)this.resource.getContents().get(0);
        if (!VView.class.isInstance(eObject)) {
            return null;
        }
        return (VView)eObject;
    }

    public void signalEcoreOutOfSync() {
        this.ecoreOutOfSync = true;
    }

    private static final class CheckMigrationRunnable
    implements IRunnableWithProgress {
        private final ViewModelMigrator migrator;
        private final URI resourceURI;
        private boolean needsMigration;

        CheckMigrationRunnable(ViewModelMigrator migrator, URI resourceURI) {
            this.migrator = migrator;
            this.resourceURI = resourceURI;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            this.needsMigration = !this.migrator.checkMigration(this.resourceURI);
        }

        public boolean getResult() {
            return this.needsMigration;
        }
    }

    private class EditorResourceChangedListener
    implements IResourceChangeListener {
        private EditorResourceChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    if (delta.getKind() == 2) {
                        FileEditorInput fei = (FileEditorInput)ViewEditorPart.this.instance.getEditorInput();
                        if (delta.getFullPath().equals((Object)fei.getFile().getFullPath())) {
                            final IWorkbenchPage page = ViewEditorPart.this.instance.getSite().getPage();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    page.closeEditor((IEditorPart)ViewEditorPart.this.instance, false);
                                }
                            });
                            return false;
                        }
                    }
                    return true;
                }
            };
            try {
                if (delta == null) {
                    return;
                }
                delta.accept(visitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private final class ReloadViewModelRunnable
    implements Runnable {
        private ReloadViewModelRunnable() {
        }

        @Override
        public void run() {
            if (ViewEditorPart.this.parent == null || ViewEditorPart.this.parent.isDisposed()) {
                IWorkbenchPage page = ViewEditorPart.this.instance.getSite().getPage();
                page.closeEditor((IEditorPart)ViewEditorPart.this.instance, true);
                return;
            }
            if (ViewEditorPart.this.render != null) {
                ViewEditorPart.this.render.dispose();
                ViewEditorPart.this.render.getSWTControl().dispose();
            }
            for (String ecorePath : ViewEditorPart.this.getView().getEcorePaths()) {
                if (ecorePath == null) continue;
                try {
                    EcoreHelper.registerEcore((String)ecorePath);
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
                }
            }
            try {
                ViewEditorPart.this.loadView(true, true);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
                return;
            }
            VView view = ViewEditorPart.this.getView();
            try {
                Activator.getViewModelRegistry().registerViewModelEditor(view, (ViewModelEditorCallback)ViewEditorPart.this.instance);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
            }
            if (view.getRootEClass() != null) {
                if (view.getRootEClass().eResource() != null) {
                    Activator.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.ide.editor.view", "The Root EClass of the view cannot be resolved." + view.getRootEClass()));
                }
            }
            ViewEditorPart.this.showView();
            ViewEditorPart.this.parent.layout(true);
        }
    }

    private class ViewPartListener
    implements IPartListener2 {
        private ViewPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (((Object)((Object)ViewEditorPart.this.instance)).equals(partRef.getPart(true))) {
                String selectedECorePath;
                VView view = ViewEditorPart.this.getView();
                if ((view.getEcorePaths().isEmpty() || ResourcesPlugin.getWorkspace().getRoot().findMember((String)view.getEcorePaths().get(0)) == null) && view.getRootEClass() != null && view.getRootEClass().eIsProxy() && (selectedECorePath = ViewEditorPart.this.selectEcoreFromWorkspace()) != null) {
                    view.getEcorePaths().add((Object)selectedECorePath);
                    ViewEditorPart.this.saveChangedView(view);
                    ViewEditorPart.this.reloadViewModel();
                }
                if (ViewEditorPart.this.ecoreOutOfSync) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog dialog = new MessageDialog(activeShell, Messages.ViewEditorPart_Warning, null, Messages.ViewEditorPart_EditorViewChanged, 4, new String[]{Messages.ViewEditorPart_Yes, Messages.ViewEditorPart_No}, 0);
                            int result = dialog.open();
                            if (result == 0) {
                                Activator.getViewModelRegistry().unregisterViewModelEditor(ViewEditorPart.this.getView(), (ViewModelEditorCallback)ViewEditorPart.this.instance);
                                Activator.getViewModelRegistry().unregister(ViewEditorPart.this.getView().getRootEClass().eResource().getURI().toString(), ViewEditorPart.this.getView());
                                ViewEditorPart.this.reloadViewModel();
                            }
                            ViewEditorPart.this.ecoreOutOfSync = false;
                        }
                    });
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

