/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.generator;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class ViewProvider
implements IViewProvider {
    public VView provideViewModel(EObject eObject, VViewModelProperties properties) {
        VView view = VViewFactory.eINSTANCE.createView();
        view.setUuid(ViewProvider.generateId(eObject.eClass(), null));
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        for (EStructuralFeature feature : this.getValidFeatures(delegator, eObject)) {
            VTableControl control;
            if (this.isTableFeature(feature)) {
                control = VTableFactory.eINSTANCE.createTableControl();
                VTableDomainModelReference tableDmr = VTableFactory.eINSTANCE.createTableDomainModelReference();
                tableDmr.setDomainModelReference(this.createModelReference(feature));
                control.setDomainModelReference((VDomainModelReference)tableDmr);
            } else {
                control = VViewFactory.eINSTANCE.createControl();
                control.setDomainModelReference(this.createModelReference(feature));
            }
            control.setReadonly(this.isReadOnly(delegator, eObject, feature));
            control.setUuid(ViewProvider.generateId(eObject.eClass(), feature));
            view.getChildren().add((Object)control);
        }
        composedAdapterFactory.dispose();
        view.setRootEClass(eObject.eClass());
        view.setLoadingProperties((VViewModelProperties)EcoreUtil.copy((EObject)properties));
        return view;
    }

    private VDomainModelReference createModelReference(EStructuralFeature feature) {
        VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        modelReference.setDomainModelEFeature(feature);
        return modelReference;
    }

    private boolean isTableFeature(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            return ref.isMany() && ref.isContainment();
        }
        return false;
    }

    private boolean isReadOnly(AdapterFactoryItemDelegator delegator, EObject owner, EStructuralFeature feature) {
        if (!feature.isChangeable()) {
            return true;
        }
        IItemPropertyDescriptor descriptor = delegator.getPropertyDescriptor((Object)owner, (Object)feature);
        return !descriptor.canSetProperty((Object)feature);
    }

    private boolean isInvalidFeature(EStructuralFeature feature) {
        return this.isContainerReference(feature) || this.isTransient(feature) || this.isVolatile(feature);
    }

    private boolean isContainerReference(EStructuralFeature feature) {
        EReference reference;
        return feature instanceof EReference && (reference = (EReference)feature).isContainer();
    }

    private boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient();
    }

    private boolean isVolatile(EStructuralFeature feature) {
        return feature.isVolatile();
    }

    private Set<EStructuralFeature> getValidFeatures(AdapterFactoryItemDelegator itemDelegator, EObject eObject) {
        EList features = eObject.eClass().getEAllStructuralFeatures();
        LinkedHashSet<EStructuralFeature> featuresToAdd = new LinkedHashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        for (EStructuralFeature feature : features) {
            propertyDescriptor = itemDelegator.getPropertyDescriptor((Object)eObject, (Object)feature);
            if (propertyDescriptor == null || this.isInvalidFeature(feature)) continue;
            featuresToAdd.add(feature);
        }
        return featuresToAdd;
    }

    private static String generateId(EClass eClass, EStructuralFeature feature) {
        StringBuilder stringBuilder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage != null) {
            stringBuilder.append(ePackage.getNsURI());
        }
        stringBuilder.append("#");
        stringBuilder.append(eClass.getName());
        if (feature != null) {
            stringBuilder.append("#");
            stringBuilder.append(feature.getName());
        }
        return String.valueOf(stringBuilder.toString().hashCode());
    }

    public double canProvideViewModel(EObject eObject, VViewModelProperties properties) {
        return 1.0;
    }
}

