/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;

public abstract class AbstractGridCell<RENDERER extends AbstractRenderer<?>> {
    private final int row;
    private final int column;
    private RENDERER renderer;
    private int horizontalSpan = 1;
    private boolean verticalGrab = true;
    private boolean verticalFill = true;
    private boolean horizontalGrab = true;
    private boolean horizontalFill = true;
    private Alignment horizontalAlignment = Alignment.BEGINNING;
    private Alignment verticalAlignment = Alignment.CENTER;

    public AbstractGridCell(int row, int column, RENDERER renderer) {
        this.row = row;
        this.column = column;
        this.renderer = renderer;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public RENDERER getRenderer() {
        return this.renderer;
    }

    public void setRenderer(RENDERER renderer) {
        this.renderer = renderer;
    }

    public int getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public void setHorizontalSpan(int horizontalSpan) {
        this.horizontalSpan = horizontalSpan;
    }

    public boolean isVerticalGrab() {
        return this.verticalGrab;
    }

    public void setVerticalGrab(boolean verticalGrab) {
        this.verticalGrab = verticalGrab;
    }

    public boolean isVerticalFill() {
        return this.verticalFill;
    }

    public void setVerticalFill(boolean verticalFill) {
        this.verticalFill = verticalFill;
    }

    public boolean isHorizontalGrab() {
        return this.horizontalGrab;
    }

    public void setHorizontalGrab(boolean horizontalGrab) {
        this.horizontalGrab = horizontalGrab;
    }

    public boolean isHorizontalFill() {
        return this.horizontalFill;
    }

    public void setHorizontalFill(boolean horizontalFill) {
        this.horizontalFill = horizontalFill;
    }

    public Alignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(Alignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Alignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(Alignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.renderer == null ? 0 : this.renderer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGridCell other = (AbstractGridCell)obj;
        if (this.column != other.column) {
            return false;
        }
        return !(this.renderer == null ? other.renderer != null : !this.renderer.equals(other.renderer));
    }

    public static enum Alignment {
        BEGINNING,
        CENTER,
        END;

    }
}

