/**
 * Copyright (c) 2011-2015 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Stefan Dirix - initial API and implementation
 */
package org.eclipse.emf.ecp.emf2web.json.generator.xtend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.emf2web.generator.Generator;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomControl;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Stefan Dirix
 */
@SuppressWarnings("all")
public abstract class JsonGenerator implements Generator {
  public abstract JsonElement createJsonElement(final EObject object);
  
  public String generate(final EObject object) {
    String _xblockexpression = null;
    {
      final JsonElement json = this.createJsonElement(object);
      GsonBuilder _gsonBuilder = new GsonBuilder();
      GsonBuilder _setPrettyPrinting = _gsonBuilder.setPrettyPrinting();
      final Gson gson = _setPrettyPrinting.create();
      _xblockexpression = gson.toJson(json);
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final JsonElement value) {
    JsonObject _xblockexpression = null;
    {
      jsonObject.add(propertyName, value);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final String value) {
    JsonObject _xblockexpression = null;
    {
      jsonObject.addProperty(propertyName, value);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final Number value) {
    JsonObject _xblockexpression = null;
    {
      jsonObject.addProperty(propertyName, value);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final Boolean value) {
    JsonObject _xblockexpression = null;
    {
      jsonObject.addProperty(propertyName, value);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final Character value) {
    JsonObject _xblockexpression = null;
    {
      jsonObject.addProperty(propertyName, value);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject _with(final JsonObject jsonObject, final String propertyName, final Collection<? extends EObject> collection) {
    JsonObject _xblockexpression = null;
    {
      final Function1<EObject, Boolean> _function = new Function1<EObject, Boolean>() {
        public Boolean apply(final EObject item) {
          boolean _isInstance = VCustomControl.class.isInstance(item);
          return Boolean.valueOf((!_isInstance));
        }
      };
      final Iterable<? extends EObject> filteredElements = IterableExtensions.filter(collection, _function);
      final Function1<EObject, JsonElement> _function_1 = new Function1<EObject, JsonElement>() {
        public JsonElement apply(final EObject item) {
          return JsonGenerator.this.createJsonElement(item);
        }
      };
      final Iterable<JsonElement> jsonElements = IterableExtensions.map(filteredElements, _function_1);
      final JsonArray jsonArray = new JsonArray();
      for (final JsonElement jsonElement : jsonElements) {
        jsonArray.add(jsonElement);
      }
      jsonObject.add(propertyName, jsonArray);
      _xblockexpression = jsonObject;
    }
    return _xblockexpression;
  }
  
  protected JsonObject with(final JsonObject jsonObject, final String propertyName, final Object value) {
    if (value instanceof Boolean) {
      return _with(jsonObject, propertyName, (Boolean)value);
    } else if (value instanceof Character) {
      return _with(jsonObject, propertyName, (Character)value);
    } else if (value instanceof Number) {
      return _with(jsonObject, propertyName, (Number)value);
    } else if (value instanceof String) {
      return _with(jsonObject, propertyName, (String)value);
    } else if (value instanceof Collection) {
      return _with(jsonObject, propertyName, (Collection<? extends EObject>)value);
    } else if (value instanceof JsonElement) {
      return _with(jsonObject, propertyName, (JsonElement)value);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(jsonObject, propertyName, value).toString());
    }
  }
}
