/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.SWTImageHelper;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LinkControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private Composite mainComposite;
    private StackLayout stackLayout;
    private Label imageHyperlink;
    private Composite linkComposite;
    private Link hyperlink;
    private final EMFFormsLocalizationService localizationService;
    private Button newReferenceBtn;
    private Button addReferenceBtn;
    private Button deleteReferenceButton;
    private Label unsetLabel;
    private ReferenceService referenceService;
    private final ImageRegistryService imageRegistryService;
    private final EMFFormsLabelProvider emfFormsLabelProvider;
    private ECPModelElementChangeListener modelElementChangeListener;
    private final EMFFormsEditSupport emfFormsEditSuppport;

    @Inject
    public LinkControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsLocalizationService localizationService, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSuppport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.localizationService = localizationService;
        this.imageRegistryService = imageRegistryService;
        this.emfFormsLabelProvider = emfFormsLabelProvider;
        this.emfFormsEditSuppport = emfFormsEditSuppport;
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)this.hyperlink);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                LinkControlSWTRenderer.this.updateChangeListener((EObject)value);
                return "<a>" + LinkControlSWTRenderer.this.getText(value) + "</a>";
            }
        });
        ISWTObservableValue tooltipValue = WidgetProperties.tooltipText().observe((Widget)this.hyperlink);
        Binding tooltipBinding = this.getDataBindingContext().bindValue((IObservableValue)tooltipValue, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControlSWTRenderer.this.getText(value);
            }
        });
        ISWTObservableValue imageValue = WidgetProperties.image().observe((Widget)this.imageHyperlink);
        Binding imageBinding = this.getDataBindingContext().bindValue((IObservableValue)imageValue, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControlSWTRenderer.this.getImage(value);
            }
        });
        ISWTObservableValue deleteButtonEnablement = WidgetProperties.enabled().observe((Widget)this.deleteReferenceButton);
        Binding deleteBinding = this.getDataBindingContext().bindValue((IObservableValue)deleteButtonEnablement, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value != null) {
                    return true;
                }
                return false;
            }
        });
        return new Binding[]{binding, tooltipBinding, imageBinding, deleteBinding};
    }

    private UpdateValueStrategy createValueExtractingUpdateStrategy() {
        return new UpdateValueStrategy(){

            public Object convert(Object value) {
                try {
                    return LinkControlSWTRenderer.this.getModelValue().getValue();
                }
                catch (DatabindingFailedException ex) {
                    LinkControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return value;
                }
            }
        };
    }

    @Override
    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        IObservableValue observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        int numColumns = 1 + this.getNumButtons();
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(numColumns).spacing(0, 0).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)composite);
        this.mainComposite = new Composite(composite, 0);
        this.mainComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.mainComposite);
        this.stackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.mainComposite, 0x1000000);
        this.unsetLabel.setText(this.getLocalizedString("LinkControl_NotSet"));
        this.unsetLabel.setBackground(this.mainComposite.getBackground());
        this.unsetLabel.setForeground(composite.getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.linkComposite = new Composite(this.mainComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.linkComposite);
        this.linkComposite.setBackground(this.mainComposite.getBackground());
        this.createHyperlink();
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.linkComposite);
        this.stackLayout.topControl = eObject.eIsSet(structuralFeature) ? this.linkComposite : this.unsetLabel;
        this.createButtons(composite);
        return composite;
    }

    protected void createButtons(Composite parent) {
        String elementDisplayName = null;
        try {
            elementDisplayName = (String)this.emfFormsLabelProvider.getDisplayName(((VControl)this.getVElement()).getDomainModelReference()).getValue();
        }
        catch (NoLabelFoundException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex));
        }
        this.createAddReferenceButton(parent, elementDisplayName);
        this.createNewReferenceButton(parent, elementDisplayName);
        this.createDeleteReferenceButton(parent, elementDisplayName);
    }

    protected void createAddReferenceButton(Composite parent, String elementDisplayName) {
        this.addReferenceBtn = new Button(parent, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.addReferenceBtn);
        this.addReferenceBtn.setImage(this.getAddReferenceButtonImage());
        this.addReferenceBtn.setToolTipText(String.valueOf(this.getLocalizedString("LinkControl_AddReference")) + elementDisplayName);
        this.addReferenceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                try {
                    EObject eObject = (EObject)((IObserving)LinkControlSWTRenderer.this.getModelValue()).getObserved();
                    EReference eReference = (EReference)LinkControlSWTRenderer.this.getModelValue().getValueType();
                    LinkControlSWTRenderer.this.getReferenceService().addExistingModelElements(eObject, eReference);
                }
                catch (DatabindingFailedException ex) {
                    LinkControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        });
    }

    protected void createNewReferenceButton(Composite parent, String elementDisplayName) {
        this.newReferenceBtn = new Button(parent, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.newReferenceBtn);
        this.newReferenceBtn.setImage(this.getNewReferenceButtonImage());
        this.newReferenceBtn.setToolTipText(String.valueOf(this.getLocalizedString("LinkControl_NewReference")) + elementDisplayName);
        this.newReferenceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                try {
                    EObject eObject = (EObject)((IObserving)LinkControlSWTRenderer.this.getModelValue()).getObserved();
                    EReference eReference = (EReference)LinkControlSWTRenderer.this.getModelValue().getValueType();
                    LinkControlSWTRenderer.this.getReferenceService().addNewModelElements(eObject, eReference);
                }
                catch (DatabindingFailedException ex) {
                    LinkControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        });
    }

    protected void createDeleteReferenceButton(Composite parent, String elementDisplayName) {
        this.deleteReferenceButton = new Button(parent, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.deleteReferenceButton);
        this.deleteReferenceButton.setImage(this.imageRegistryService.getImage(this.getIconBundle(), "icons/unset_reference.png"));
        this.deleteReferenceButton.setToolTipText(this.getLocalizedString("LinkControl_DeleteReference"));
        this.deleteReferenceButton.addSelectionListener((SelectionListener)new DeleteSelectionAdapter());
    }

    private Bundle getIconBundle() {
        return FrameworkUtil.getBundle(LinkControlSWTRenderer.class);
    }

    protected String getText(Object value) {
        String linkName = this.emfFormsEditSuppport.getText(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel(), value);
        return linkName == null ? "" : linkName;
    }

    protected Image getImage(Object value) {
        if (value == null) {
            return null;
        }
        Object imageDescription = this.emfFormsEditSuppport.getImage(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel(), value);
        if (imageDescription == null) {
            return null;
        }
        Image image = SWTImageHelper.getImage((Object)imageDescription);
        return image;
    }

    private Image getNewReferenceButtonImage() {
        return this.imageRegistryService.getImage(this.getIconBundle(), "icons/set_reference.png");
    }

    private Image getAddReferenceButtonImage() {
        return this.imageRegistryService.getImage(this.getIconBundle(), "icons/reference.png");
    }

    private void createHyperlink() throws DatabindingFailedException {
        this.imageHyperlink = new Label(this.linkComposite, 0);
        this.imageHyperlink.setBackground(this.linkComposite.getBackground());
        this.hyperlink = new Link(this.linkComposite, 0);
        this.hyperlink.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_reference");
        this.hyperlink.setBackground(this.linkComposite.getBackground());
        this.hyperlink.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                try {
                    LinkControlSWTRenderer.this.linkClicked((EObject)LinkControlSWTRenderer.this.getModelValue().getValue());
                }
                catch (DatabindingFailedException ex) {
                    LinkControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.hyperlink);
    }

    protected void linkClicked(EObject value) {
        ReferenceService referenceService = this.getReferenceService();
        referenceService.openInNewContext(value);
    }

    protected ReferenceService getReferenceService() {
        if (this.referenceService == null) {
            this.referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
        }
        return this.referenceService;
    }

    private String getLocalizedString(String key) {
        return this.localizationService.getString(LinkControlSWTRenderer.class, key);
    }

    protected int getNumButtons() {
        return 3;
    }

    @Override
    protected String getUnsetText() {
        return this.getLocalizedString("LinkControl_NoLinkSetClickToSetLink");
    }

    private void updateChangeListener(EObject value) {
        if (this.modelElementChangeListener != null) {
            if (this.modelElementChangeListener.getTarget().equals(value)) {
                return;
            }
            this.modelElementChangeListener.remove();
            this.modelElementChangeListener = null;
        }
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.mainComposite.layout();
            }
        } else {
            if (this.stackLayout.topControl != this.linkComposite) {
                this.stackLayout.topControl = this.linkComposite;
                this.mainComposite.layout();
            }
            this.modelElementChangeListener = new ECPModelElementChangeListener(value){

                public void onChange(Notification notification) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            LinkControlSWTRenderer.this.getDataBindingContext().updateTargets();
                            LinkControlSWTRenderer.this.linkComposite.layout();
                        }
                    });
                }
            };
        }
    }

    class DeleteSelectionAdapter
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        DeleteSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                EReference reference = (EReference)LinkControlSWTRenderer.this.getModelValue().getValueType();
                EObject object = LinkControlSWTRenderer.this.getViewModelContext().getDomainModel();
                if (reference.isContainment()) {
                    if (this.askConfirmation(object)) {
                        this.delete(object, reference);
                    }
                } else {
                    this.delete(object, reference);
                }
            }
            catch (DatabindingFailedException ex) {
                LinkControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }

        private void delete(EObject eObject, EReference reference) {
            EditingDomain editingDomain = LinkControlSWTRenderer.this.getEditingDomain(eObject);
            Command removeCommand = SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)reference, null);
            if (removeCommand.canExecute()) {
                editingDomain.getCommandStack().execute(removeCommand);
            }
        }

        private boolean askConfirmation(EObject eObject) {
            String modelElementName = LinkControlSWTRenderer.this.getText(eObject);
            String question = String.valueOf(LinkControlSWTRenderer.this.getLocalizedString("LinkControl_DeleteModelQuestion")) + modelElementName + LinkControlSWTRenderer.this.getLocalizedString("LinkControl_QuestionMark");
            MessageDialog dialog = new MessageDialog(null, LinkControlSWTRenderer.this.getLocalizedString("LinkControl_DeleteReferenceConfirmation"), null, question, 3, new String[]{LinkControlSWTRenderer.this.getLocalizedString("LinkControl_DeleteReferenceYes"), LinkControlSWTRenderer.this.getLocalizedString("LinkControl_DeleteReferenceNo")}, 0);
            boolean confirm = false;
            if (dialog.open() == 0) {
                confirm = true;
            }
            return confirm;
        }
    }
}

