/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.compoundcontrol.swt;

import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.model.common.util.RendererUtil;
import org.eclipse.emf.ecp.view.spi.compoundcontrol.model.VCompoundControl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.alignment.model.AlignmentType;
import org.eclipse.emf.ecp.view.template.style.alignment.model.VTControlLabelAlignmentStyleProperty;
import org.eclipse.emf.ecp.view.template.style.labelwidth.model.VTLabelWidthStyleProperty;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompoundControlSWTRenderer
extends AbstractSWTRenderer<VCompoundControl> {
    private static final String SEPARATOR = "/";
    private SWTGridDescription rendererGridDescription;
    private final EMFFormsLabelProvider labelProvider;
    private EMFDataBindingContext dataBindingContext;
    private final EMFFormsRendererFactory rendererFactory;
    private LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> elementRendererMap;
    private final VTViewTemplateProvider viewTemplateProvider;

    @Inject
    public CompoundControlSWTRenderer(VCompoundControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsLabelProvider labelProvider, EMFFormsRendererFactory rendererFactory, VTViewTemplateProvider viewTemplateProvider) {
        super((VElement)vElement, viewContext, reportService);
        this.labelProvider = labelProvider;
        this.rendererFactory = rendererFactory;
        this.viewTemplateProvider = viewTemplateProvider;
    }

    protected EMFFormsLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected EMFFormsRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    protected DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> getElementRendererMap() {
        return this.elementRendererMap;
    }

    private void setElementRendererMap(LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> elementRendererMap) {
        this.elementRendererMap = elementRendererMap;
    }

    protected VTViewTemplateProvider getViewTemplateProvider() {
        return this.viewTemplateProvider;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 2, (AbstractSWTRenderer)this);
            SWTGridCell label = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            label.setHorizontalGrab(false);
            label.setVerticalGrab(false);
            label.setVerticalFill(false);
            Optional<Integer> labelWidth = this.getLabelWidth();
            if (labelWidth.isPresent()) {
                label.setPreferredSize(((Integer)labelWidth.get()).intValue(), label.getPreferredSize() == null ? -1 : label.getPreferredSize().y);
            }
            SWTGridCell controls = (SWTGridCell)this.rendererGridDescription.getGrid().get(1);
            controls.setVerticalGrab(false);
            controls.setVerticalFill(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        switch (cell.getColumn()) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                return this.createControls(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", cell.toString(), ((Object)((Object)this)).toString()));
    }

    protected Control createLabel(Composite parent) {
        EList controls = ((VCompoundControl)this.getVElement()).getControls();
        Composite labelComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2 * controls.size() - 1).equalWidth(false).applyTo(labelComposite);
        AlignmentType labelAlignment = this.getLabelAlignment();
        int i = 0;
        while (i < controls.size()) {
            if (i != 0) {
                Label separatorLabel = new Label(labelComposite, 0);
                GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)separatorLabel);
                separatorLabel.setText(SEPARATOR);
            }
            boolean grab = false;
            int stylebits = 0;
            if (labelAlignment == AlignmentType.LEFT && i == controls.size() - 1) {
                grab = true;
            } else if (labelAlignment == AlignmentType.RIGHT && i == 0) {
                grab = true;
                stylebits = 131072;
            }
            Label label = new Label(labelComposite, stylebits);
            GridDataFactory.fillDefaults().grab(grab, false).align(4, 0x1000000).applyTo((Control)label);
            VControl control = (VControl)controls.get(i);
            try {
                ISWTObservableValue targetValue = SWTObservables.observeText((Control)label);
                IObservableValue modelValue = this.getLabelProvider().getDisplayName(control.getDomainModelReference(), this.getViewModelContext().getDomainModel());
                Binding bindValue = this.getDataBindingContext().bindValue((IObservableValue)targetValue, modelValue);
                bindValue.updateModelToTarget();
            }
            catch (NoLabelFoundException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
            ++i;
        }
        labelComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
        return labelComposite;
    }

    protected Optional<Integer> getLabelWidth() {
        VTLabelWidthStyleProperty styleProperty = (VTLabelWidthStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTLabelWidthStyleProperty.class);
        if (styleProperty == null || !styleProperty.isSetWidth()) {
            return Optional.empty();
        }
        return Optional.of((Object)styleProperty.getWidth());
    }

    protected AlignmentType getLabelAlignment() {
        VTControlLabelAlignmentStyleProperty styleProperty = (VTControlLabelAlignmentStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTControlLabelAlignmentStyleProperty.class);
        if (styleProperty == null) {
            return AlignmentType.LEFT;
        }
        return styleProperty.getType();
    }

    protected Control createControls(Composite parent) {
        return this.createControls(parent, 0);
    }

    protected Control createControls(Composite parent, int cellsToSkip) {
        this.initChildRendererMap();
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        columnComposite.setLayout(this.getColumnLayout(this.getElementRendererMap().size(), false));
        for (VContainedElement child : this.getElementRendererMap().keySet()) {
            AbstractSWTRenderer<VElement> renderer = this.getElementRendererMap().get(child);
            Composite column = new Composite(columnComposite, 0);
            column.setBackground(parent.getBackground());
            column.setLayoutData(this.getSpanningLayoutData(child, 1, 1));
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            int columns = gridDescription.getColumns() - cellsToSkip;
            column.setLayout(this.getColumnLayout(columns < 1 ? 1 : columns, false));
            try {
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    if (cellsToSkip > 0) {
                        --cellsToSkip;
                        continue;
                    }
                    Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, column);
                    if (control == null) continue;
                    control.setLayoutData(this.getLayoutData(childGridCell, gridDescription, gridDescription, gridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), this.getViewModelContext().getDomainModel(), control));
                }
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(column);
                }
            }
            catch (NoPropertyDescriptorFoundExeption e) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            }
            catch (NoRendererFoundException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            }
        }
        return columnComposite;
    }

    protected void initChildRendererMap() {
        if (this.getElementRendererMap() != null) {
            return;
        }
        this.setElementRendererMap(new LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>>());
        for (VControl child : ((VCompoundControl)this.getVElement()).getControls()) {
            AbstractSWTRenderer renderer;
            child.setLabelAlignment(LabelAlignment.NONE);
            try {
                renderer = this.getRendererFactory().getRendererInstance((VElement)child, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, String.format("No Renderer for %s found.", child.eClass().getName())));
                continue;
            }
            this.getElementRendererMap().put((VContainedElement)child, (AbstractSWTRenderer<VElement>)renderer);
        }
    }

    protected Layout getColumnLayout(int numColumns, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numColumns, (boolean)equalWidth);
    }

    protected Object getSpanningLayoutData(VContainedElement child, int spanX, int spanY) {
        return LayoutProviderHelper.getSpanningLayoutData((int)spanX, (int)spanY);
    }

    protected Object getLayoutData(SWTGridCell gridCell, SWTGridDescription controlGridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, EObject domainModel, Control control) {
        return LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)controlGridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (EObject)domainModel, (Control)control);
    }

    protected void dispose() {
        if (this.getDataBindingContext() != null) {
            this.getDataBindingContext().dispose();
        }
        super.dispose();
    }
}

