/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.core.rap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.rap.SessionProvider;
import org.eclipse.emf.ecp.internal.core.ECPProviderRegistryImpl;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ECPProviderRegistryFactory
implements ServiceFactory<ECPProviderRegistry>,
UISessionListener {
    private SessionProvider sessionProvider;
    private final Map<String, ECPProviderRegistry> sessionRegistry = new HashMap<String, ECPProviderRegistry>();

    public ECPProviderRegistryFactory() {
        this.init();
    }

    public void init() {
        this.getSessionProvider();
    }

    private SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(SessionProvider.class);
            this.sessionProvider = (SessionProvider)bundleContext.getService(serviceReference);
        }
        return this.sessionProvider;
    }

    public ECPProviderRegistry getService(Bundle bundle, ServiceRegistration<ECPProviderRegistry> registration) {
        ECPProviderRegistryImpl ecpProviderRegistry;
        String sessionId = this.getSessionProvider().getSessionId();
        this.getSessionProvider().registerListenerWithSession(this);
        if (this.sessionRegistry.containsKey(sessionId)) {
            ecpProviderRegistry = this.sessionRegistry.get(sessionId);
        } else {
            ecpProviderRegistry = new ECPProviderRegistryImpl();
            this.sessionRegistry.put(sessionId, (ECPProviderRegistry)ecpProviderRegistry);
            ((Lifecycle)ecpProviderRegistry).activate();
        }
        return ecpProviderRegistry;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ECPProviderRegistry> registration, ECPProviderRegistry service) {
    }

    public void beforeDestroy(UISessionEvent event) {
        this.sessionRegistry.remove(event.getUISession().toString());
    }
}

