/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.rulerepository.tooling.merge;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emfforms.internal.rulerepository.tooling.merge.MergeHelper;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.eclipse.emfforms.spi.rulerepository.model.VRuleRepository;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeWithViewHandler
extends AbstractHandler {
    private static final String ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING = "org.eclipse.emfforms.rulerepository.tooling";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IFile selectedFile = (IFile)((TreeSelection)TreeSelection.class.cast(currentSelection)).getFirstElement();
        WorkspaceModifyOperation operation = this.mergeRuleRepoWithView(activeShell, selectedFile);
        try {
            if (operation != null) {
                HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).run(false, false, (IRunnableWithProgress)operation);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            ErrorDialog.openError((Shell)activeShell, (String)"Error", (String)ex.getMessage(), (IStatus)new Status(4, ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING, ex.getMessage(), (Throwable)ex));
        }
        return null;
    }

    private WorkspaceModifyOperation mergeRuleRepoWithView(Shell activeShell, IFile selectedFile) {
        ResourceSet resourceSet;
        try {
            resourceSet = ResourceSetHelpers.loadResourceSetWithProxies((URI)URI.createPlatformResourceURI((String)selectedFile.getFullPath().toOSString(), (boolean)false), (BasicCommandStack)new BasicCommandStack(), null);
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)activeShell, (String)"Error", (String)ex.getMessage(), (IStatus)new Status(4, ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING, ex.getMessage(), (Throwable)ex));
            return null;
        }
        return this.mergeRuleRepoWithView(activeShell, resourceSet, new ViewAndRepositoryProvider(){

            @Override
            public ViewAndRepository getViewAndRepository(ResourceSet resourceSet) {
                return MergeWithViewHandler.this.extractViewAndRepository(resourceSet);
            }
        }, new MergedViewPathProvider(){

            @Override
            public String getPath(Shell activeShell, VView view) {
                return MergeWithViewHandler.this.getMergedViewPath(activeShell, view);
            }
        }, new OperationProvider(){

            @Override
            public WorkspaceModifyOperation getOperation(Shell activeShell, String mergedViewPath, VView mergedView) {
                return MergeWithViewHandler.this.getWorkspaceOperation(activeShell, mergedViewPath, mergedView);
            }
        }, new MergeProvider(){

            @Override
            public VView merge(VRuleRepository repository, VView view) {
                return MergeWithViewHandler.this.mergeRuleRepository(repository, view);
            }
        });
    }

    WorkspaceModifyOperation mergeRuleRepoWithView(Shell activeShell, ResourceSet resourceSet, ViewAndRepositoryProvider viewAndRepositoryProvider, MergedViewPathProvider pathProvider, OperationProvider operationProvider, MergeProvider mergeProvider) {
        ViewAndRepository vur = viewAndRepositoryProvider.getViewAndRepository(resourceSet);
        if (vur.getRuleRepository() == null) {
            ErrorDialog.openError((Shell)activeShell, (String)"Missing Rule Repository", (String)"The file doesn't contain a rule repository!", (IStatus)new Status(4, ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING, "No Rule Repository!"));
            return null;
        }
        if (vur.getView() == null) {
            ErrorDialog.openError((Shell)activeShell, (String)"Missing View", (String)"You must link a view model first!", (IStatus)new Status(4, ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING, "No View model linked!"));
            return null;
        }
        String mergedViewPath = pathProvider.getPath(activeShell, vur.getView());
        VView mergedView = mergeProvider.merge(vur.getRuleRepository(), vur.getView());
        return operationProvider.getOperation(activeShell, mergedViewPath, mergedView);
    }

    VView mergeRuleRepository(VRuleRepository repository, VView view) {
        MergeHelper.merge(repository);
        return (VView)EcoreUtil.copy((EObject)view);
    }

    String getMergedViewPath(Shell activeShell, VView view) {
        SaveAsDialog sad = new SaveAsDialog(activeShell);
        URI viewURI = view.eResource().getURI();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String mergedViewPath = String.valueOf(viewURI.trimFileExtension().toPlatformString(false).substring(1)) + "_merged." + viewURI.fileExtension();
        IFile file = workspace.getRoot().getFile((IPath)new Path(mergedViewPath));
        sad.setOriginalFile(file);
        int result = sad.open();
        if (result == 1) {
            return null;
        }
        return sad.getResult().toString();
    }

    WorkspaceModifyOperation getWorkspaceOperation(final Shell activeShell, final String mergedViewPath, final VView mergedView) {
        return new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createPlatformResourceURI((String)mergedViewPath, (boolean)true);
                Resource resource = resourceSet.createResource(fileURI);
                resource.getContents().add((Object)mergedView);
                try {
                    try {
                        resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
                    }
                    catch (IOException ex) {
                        ErrorDialog.openError((Shell)activeShell, (String)"Error", (String)ex.getMessage(), (IStatus)new Status(4, MergeWithViewHandler.ORG_ECLIPSE_EMFFORMS_RULEREPOSITORY_TOOLING, ex.getMessage(), (Throwable)ex));
                        progressMonitor.done();
                        return;
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
    }

    ViewAndRepository extractViewAndRepository(ResourceSet resourceSet) {
        ViewAndRepository result = new ViewAndRepository();
        for (Resource resource : resourceSet.getResources()) {
            if (resource.getContents().isEmpty()) continue;
            EObject eObject = (EObject)resource.getContents().get(0);
            if (VView.class.isInstance(eObject)) {
                result.setView((VView)VView.class.cast(eObject));
            }
            if (!VRuleRepository.class.isInstance(eObject)) continue;
            result.setRuleRepository((VRuleRepository)VRuleRepository.class.cast(eObject));
        }
        return result;
    }

    public static interface MergeProvider {
        public VView merge(VRuleRepository var1, VView var2);
    }

    public static interface MergedViewPathProvider {
        public String getPath(Shell var1, VView var2);
    }

    public static interface OperationProvider {
        public WorkspaceModifyOperation getOperation(Shell var1, String var2, VView var3);
    }

    public static class ViewAndRepository {
        private VView view;
        private VRuleRepository ruleRepository;

        public VView getView() {
            return this.view;
        }

        public void setView(VView view) {
            this.view = view;
        }

        public VRuleRepository getRuleRepository() {
            return this.ruleRepository;
        }

        public void setRuleRepository(VRuleRepository ruleRepository) {
            this.ruleRepository = ruleRepository;
        }
    }

    public static interface ViewAndRepositoryProvider {
        public ViewAndRepository getViewAndRepository(ResourceSet var1);
    }
}

