/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.datatemplate;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.ui.view.swt.reference.CreateNewModelElementStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EClassSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceStrategyUtil;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.core.services.datatemplate.TemplateFilterService;
import org.eclipse.emfforms.core.services.datatemplate.TemplateProvider;
import org.eclipse.emfforms.datatemplate.Template;
import org.eclipse.emfforms.internal.core.services.datatemplate.BlankTemplateProvider;
import org.eclipse.emfforms.internal.core.services.datatemplate.SelectSubclassAndTemplateWizard;
import org.eclipse.emfforms.spi.bazaar.BazaarUtil;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="TemplateCreateNewModelElementStrategyProvider", property={"service.ranking:Integer=10"})
public class TemplateCreateNewModelElementStrategyProvider
extends ReferenceServiceCustomizationVendor<CreateNewModelElementStrategy>
implements CreateNewModelElementStrategy.Provider {
    private final Set<TemplateProvider> templateProviders = new LinkedHashSet<TemplateProvider>();
    private EMFFormsLocalizationService localizationService;
    private final Bazaar<EClassSelectionStrategy> eclassSelectionStrategyBazaar = BazaarUtil.createBazaar((Object)EClassSelectionStrategy.NULL);
    private final Bazaar<TemplateFilterService> templateFilterBazaar = BazaarUtil.createBazaar((Object)TemplateFilterService.NULL);
    private ComponentContext context;

    @Activate
    void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    void deactivate() {
        this.context = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    void registerTemplateProvider(TemplateProvider templateProvider) {
        this.templateProviders.add(templateProvider);
    }

    void unregisterTemplateProvider(TemplateProvider templateProvider) {
        this.templateProviders.remove(templateProvider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addFilterServiceProvider(TemplateFilterService.Provider provider) {
        this.templateFilterBazaar.addVendor((Vendor)provider);
    }

    void removeFilterServiceProvider(TemplateFilterService.Provider provider) {
        this.templateFilterBazaar.removeVendor((Vendor)provider);
    }

    @Reference
    void setLocalizationService(EMFFormsLocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected boolean handles(EObject owner, EReference reference) {
        for (TemplateProvider provider : this.templateProviders) {
            if (!provider.canProvideTemplates(owner, reference)) continue;
            return true;
        }
        return false;
    }

    protected Set<Template> collectAvailableTemplates(EObject eObject, EReference eReference) {
        LinkedHashSet<Template> templates = new LinkedHashSet<Template>();
        Predicate<? super Template> filter = this.getFilter(eObject, eReference);
        for (TemplateProvider provider : this.templateProviders) {
            Set<Template> providedTemplates;
            if (!provider.canProvideTemplates(eObject, eReference)) continue;
            if (provider instanceof BlankTemplateProvider) {
                EClassSelectionStrategy eClassSelectionStrategy = ReferenceStrategyUtil.createDynamicEClassSelectionStrategy(this.eclassSelectionStrategyBazaar, (ComponentContext)this.context);
                providedTemplates = ((BlankTemplateProvider)provider).provideTemplates(eObject, eReference, eClassSelectionStrategy);
            } else {
                providedTemplates = provider.provideTemplates(eObject, eReference);
            }
            if (filter == null) {
                templates.addAll(providedTemplates);
                continue;
            }
            providedTemplates.stream().filter(filter).forEach(templates::add);
        }
        return templates;
    }

    @Create
    public CreateNewModelElementStrategy createCreateNewModelElementStrategy() {
        EClassSelectionStrategy eClassSelectionStrategy = ReferenceStrategyUtil.createDynamicEClassSelectionStrategy(this.eclassSelectionStrategyBazaar, (ComponentContext)this.context);
        return new Strategy(eClassSelectionStrategy);
    }

    protected Predicate<? super Template> getFilter(EObject owner, EReference reference) {
        BazaarContext bazaarContext = ReferenceStrategyUtil.createBazaarContext((ComponentContext)this.context, (EObject)owner, (EReference)reference);
        return this.templateFilterBazaar.createProducts(bazaarContext).stream().map(service -> service.getTemplateFilter(owner, reference)).filter(Objects::nonNull).reduce(Predicate::and).orElse(null);
    }

    private static <T, R> Function<T, R> ignoreException(Function<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                return null;
            }
        };
    }

    class Strategy
    implements CreateNewModelElementStrategy {
        private final EClassSelectionStrategy classSelectionStrategy;

        Strategy(EClassSelectionStrategy classSelectionStrategy) {
            this.classSelectionStrategy = classSelectionStrategy;
        }

        public Optional<EObject> createNewModelElement(EObject owner, EReference reference) {
            Set<Template> availableTemplates = TemplateCreateNewModelElementStrategyProvider.this.collectAvailableTemplates(owner, reference);
            if (availableTemplates.isEmpty()) {
                return Optional.empty();
            }
            LinkedHashSet availableClasses = new LinkedHashSet(EMFUtils.getSubClasses((EClass)reference.getEReferenceType()));
            LinkedHashSet<EClass> subClasses = new LinkedHashSet<EClass>(this.classSelectionStrategy.collectEClasses(owner, reference, availableClasses));
            Template selected = availableTemplates.iterator().next();
            if (availableTemplates.size() > 1) {
                Set templateClasses = availableTemplates.stream().map(Template::getInstance).filter(Objects::nonNull).map(TemplateCreateNewModelElementStrategyProvider.ignoreException(EObject::eClass)).filter(Objects::nonNull).collect(Collectors.toSet());
                subClasses.retainAll(templateClasses);
                Optional<Template> selectedElement = this.showSelectModelInstancesDialog(subClasses, availableTemplates);
                if (selectedElement.isPresent()) {
                    selected = (Template)selectedElement.get();
                } else {
                    return Optional.empty();
                }
            }
            return Optional.of((Object)EcoreUtil.copy((EObject)selected.getInstance()));
        }

        protected Optional<Template> showSelectModelInstancesDialog(Set<EClass> subClasses, Set<Template> availableInstances) {
            SelectSubclassAndTemplateWizard wizard = new SelectSubclassAndTemplateWizard(TemplateCreateNewModelElementStrategyProvider.this.localizationService.getString(TemplateCreateNewModelElementStrategyProvider.class, "TemplateCreateNewModelElementStrategyProvider_wizardTitle"), subClasses, availableInstances, TemplateCreateNewModelElementStrategyProvider.this.localizationService);
            WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wd.open();
            return wizard.getSelectedTemplate();
        }
    }
}

