/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.ConditionServiceManager;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.ConditionService;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Deactivate;

abstract class CompositeConditionService<C extends Condition>
implements ConditionService<C> {
    private ServiceReference<ConditionServiceManager> conditionServiceManagerReference;
    private ConditionServiceManager conditionServiceManager;

    protected CompositeConditionService() {
    }

    @Deactivate
    void deactivate() {
        this.conditionServiceManager = null;
        if (this.conditionServiceManagerReference != null) {
            this.getBundleContext().ungetService(this.conditionServiceManagerReference);
        }
    }

    private BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }

    @Override
    public Set<UniqueSetting> getConditionSettings(C condition, EObject domainModel) {
        LinkedHashSet<UniqueSetting> result = new LinkedHashSet<UniqueSetting>();
        ConditionServiceManager manager = this.getConditionServiceManager();
        List<EObject> targets = this.getTargets(condition, domainModel);
        for (Condition component : this.components(condition)) {
            for (EObject next : targets) {
                result.addAll(manager.getConditionSettings(component, next));
            }
        }
        return result;
    }

    protected List<? extends EObject> getTargets(C condition, EObject domainModel) {
        return Collections.singletonList(domainModel);
    }

    protected abstract Iterable<? extends Condition> components(C var1);

    @Override
    public Set<VDomainModelReference> getDomainModelReferences(C condition) {
        LinkedHashSet<VDomainModelReference> result = new LinkedHashSet<VDomainModelReference>();
        ConditionServiceManager manager = this.getConditionServiceManager();
        for (Condition next : this.components(condition)) {
            result.addAll(manager.getDomainModelReferences(next));
        }
        return result;
    }

    @Override
    public boolean evaluate(C condition, EObject domainModel) {
        return condition.evaluate(domainModel);
    }

    @Override
    public boolean evaluateChangedValues(C condition, EObject domainModel, Map<EStructuralFeature.Setting, Object> possibleNewValues) {
        return condition.evaluateChangedValues(domainModel, possibleNewValues);
    }

    private ConditionServiceManager getConditionServiceManager() {
        if (this.conditionServiceManager == null) {
            BundleContext context = this.getBundleContext();
            this.conditionServiceManagerReference = context.getServiceReference(ConditionServiceManager.class);
            if (this.conditionServiceManagerReference == null) {
                throw new IllegalStateException("No ConditionServiceManager");
            }
            this.conditionServiceManager = (ConditionServiceManager)context.getService(this.conditionServiceManagerReference);
        }
        return this.conditionServiceManager;
    }
}

