/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.properties;

import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.internal.core.Messages;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public final class ECPProjectProperties
extends Properties<ECPProject> {
    private static final String UNKNOWN_PROVIDER = "<unknown provider>";
    private static final IProperties<ECPProject> INSTANCE = new ECPProjectProperties();

    private ECPProjectProperties() {
        super(ECPProject.class);
        this.add((Property)new Property<ECPProject>("name", Messages.ECPProjectProperties_Name, Messages.ECPProjectProperties_NameOfProject){

            protected Object eval(ECPProject project) {
                return project.getName();
            }
        });
        this.add((Property)new Property<ECPProject>("repositoryName"){

            protected Object eval(ECPProject project) {
                return project.getRepository().getName();
            }
        });
        this.add((Property)new Property<ECPProject>("repositoryLabel", Messages.ECPProjectProperties_Repository, Messages.ECPProjectProperties_RepositoryOfProject){

            protected Object eval(ECPProject project) {
                return project.getRepository().getLabel();
            }
        });
        this.add((Property)new Property<ECPProject>("providerName"){

            protected Object eval(ECPProject project) {
                ECPProvider provider = project.getProvider();
                if (provider != null) {
                    return provider.getName();
                }
                return ECPProjectProperties.UNKNOWN_PROVIDER;
            }
        });
        this.add((Property)new Property<ECPProject>("providerLabel", Messages.ECPProjectProperties_Provider, Messages.ECPProjectProperties_ProviderOfProject){

            protected Object eval(ECPProject project) {
                ECPProvider provider = project.getProvider();
                if (provider != null) {
                    return provider.getLabel();
                }
                return ECPProjectProperties.UNKNOWN_PROVIDER;
            }
        });
        this.add((Property)new Property<ECPProject>("isDirty", Messages.ECPProjectProperties_IsProjectDirty, Messages.ECPProjectProperties_HasProjectUnsavedChanges){

            protected Object eval(ECPProject project) {
                return project.hasDirtyContents();
            }
        });
        this.add((Property)new Property<ECPProject>("open"){

            protected Object eval(ECPProject closeable) {
                return closeable.isOpen();
            }
        });
        this.add((Property)new Property<ECPProject>("closed"){

            protected Object eval(ECPProject closeable) {
                return !closeable.isOpen();
            }
        });
    }

    public static final class Tester
    extends DefaultPropertyTester<ECPProject> {
        private static final String NAMESPACE = "org.eclipse.emf.ecp.core.project";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

