/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.common.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.Diagnostic;

public interface DiagnosticFrequencyMap
extends Iterable<Diagnostic> {
    public void clear();

    public int size();

    public boolean isEmpty();

    public boolean isFull();

    public int getDiscardedSeverity();

    public boolean add(Diagnostic var1);

    public void addDiagnosticFilter(Predicate<? super Diagnostic> var1);

    default public boolean addAll(Collection<?> diagnostics) {
        boolean result = false;
        for (Object next : diagnostics) {
            if (!(next instanceof Diagnostic)) continue;
            boolean bl = result = this.add((Diagnostic)next) || result;
            if (!result) break;
        }
        return result;
    }

    default public void appendTo(Collection<? super Diagnostic> diagnostics) {
        for (Diagnostic next : this) {
            diagnostics.add((Diagnostic)next);
        }
    }

    public static DiagnosticFrequencyMap unlimited() {
        return new Unlimited();
    }

    public static DiagnosticFrequencyMap limitedTo(int size) {
        return new Limited(size);
    }

    public static class Limited
    extends Unlimited {
        private final int limit;

        Limited(int limit) {
            super(Limited.checkLimit(limit));
            this.limit = limit;
        }

        private static int checkLimit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("negative limit");
            }
            return limit;
        }

        @Override
        public boolean isFull() {
            return this.errors.size() >= this.limit;
        }

        @Override
        boolean canAdd(int severityMask) {
            int count = 0;
            if ((severityMask & 4) != 0) {
                count += this.errors.size();
            }
            if ((severityMask & 2) != 0) {
                count += this.warnings.size();
            }
            if ((severityMask & 1) != 0) {
                count += this.infos.size();
            }
            return count < this.limit;
        }

        @Override
        boolean discard(int severity) {
            if (this.size() < this.limit) {
                return false;
            }
            Diagnostic discarded = null;
            switch (severity) {
                case 4: 
                case 8: {
                    throw new IllegalArgumentException("Cannot discard errors");
                }
                case 2: {
                    if (!this.infos.isEmpty()) {
                        discarded = (Diagnostic)this.infos.remove(this.infos.size() - 1);
                        break;
                    }
                    if (this.warnings.isEmpty()) break;
                    discarded = (Diagnostic)this.warnings.remove(this.warnings.size() - 1);
                    break;
                }
                case 1: {
                    if (this.infos.isEmpty()) break;
                    discarded = (Diagnostic)this.infos.remove(this.infos.size() - 1);
                    break;
                }
            }
            if (discarded != null) {
                this.discarded(discarded.getSeverity());
            }
            return discarded != null;
        }
    }

    public static class Unlimited
    implements DiagnosticFrequencyMap {
        final List<Diagnostic> errors;
        final List<Diagnostic> warnings;
        final List<Diagnostic> infos;
        private Predicate<Diagnostic> filter;
        private int size;
        private int discardedSeverity = 0;

        Unlimited() {
            this(10);
        }

        Unlimited(int capacity) {
            this.errors = new ArrayList<Diagnostic>(capacity);
            this.warnings = new ArrayList<Diagnostic>(capacity);
            this.infos = new ArrayList<Diagnostic>(capacity);
        }

        @Override
        public void clear() {
            this.size = 0;
            this.discardedSeverity = 0;
            this.errors.clear();
            this.warnings.clear();
            this.infos.clear();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public int getDiscardedSeverity() {
            return this.discardedSeverity;
        }

        @Override
        public boolean add(Diagnostic diagnostic) {
            if (this.isFull() || !this.filter(diagnostic)) {
                this.discarded(diagnostic.getSeverity());
                return false;
            }
            boolean result = false;
            switch (diagnostic.getSeverity()) {
                case 4: 
                case 8: {
                    if (this.canAdd(4)) {
                        result = this.errors.add(diagnostic);
                        if (this.discard(2)) break;
                        ++this.size;
                        break;
                    }
                    this.discarded(diagnostic.getSeverity());
                    break;
                }
                case 2: {
                    if (this.canAdd(6)) {
                        result = this.warnings.add(diagnostic);
                        if (this.discard(1)) break;
                        ++this.size;
                        break;
                    }
                    this.discarded(2);
                    break;
                }
                case 1: {
                    if (this.canAdd(7)) {
                        result = this.infos.add(diagnostic);
                        if (this.discard(0)) break;
                        ++this.size;
                        break;
                    }
                    this.discarded(1);
                    break;
                }
            }
            return result;
        }

        @Override
        public void addDiagnosticFilter(Predicate<? super Diagnostic> filter) {
            if (this.filter == null) {
                Predicate<? super Diagnostic> cast = filter;
                this.filter = cast;
            } else {
                this.filter = this.filter.and(filter);
            }
        }

        private boolean filter(Diagnostic diagnostic) {
            return this.filter == null || this.filter.test(diagnostic);
        }

        boolean canAdd(int severityMask) {
            return true;
        }

        boolean discard(int severity) {
            return false;
        }

        void discarded(int severity) {
            if (this.discardedSeverity < severity) {
                this.discardedSeverity = severity;
            }
        }

        @Override
        public void appendTo(Collection<? super Diagnostic> diagnostics) {
            if (!this.errors.isEmpty()) {
                diagnostics.addAll(this.errors);
            }
            if (!this.warnings.isEmpty()) {
                diagnostics.addAll(this.warnings);
            }
            if (!this.infos.isEmpty()) {
                diagnostics.addAll(this.infos);
            }
        }

        @Override
        public Iterator<Diagnostic> iterator() {
            return new Iterator<Diagnostic>(){
                private final Iterator<Iterator<Diagnostic>> iitr;
                private Iterator<Diagnostic> itr;
                {
                    this.iitr = Arrays.asList(unlimited.errors.iterator(), unlimited.warnings.iterator(), unlimited.infos.iterator()).iterator();
                    this.itr = this.iitr.next();
                }

                private Iterator<Diagnostic> itr() {
                    while (!this.itr.hasNext() && this.iitr.hasNext()) {
                        this.itr = this.iitr.next();
                    }
                    return this.itr;
                }

                @Override
                public boolean hasNext() {
                    return this.itr().hasNext();
                }

                @Override
                public Diagnostic next() {
                    return this.itr().next();
                }
            };
        }
    }
}

