/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.nebula.grid.GridClearKeyListener;
import org.eclipse.emf.ecp.view.internal.table.nebula.grid.GridCopyKeyListener;
import org.eclipse.emf.ecp.view.internal.table.nebula.grid.GridCutKeyListener;
import org.eclipse.emf.ecp.view.internal.table.nebula.grid.GridPasteKeyListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridTableViewerFactory;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundStyleProperty;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.table.ButtonBarBuilder;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTBuilder;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GridControlSWTRenderer
extends TableControlSWTRenderer {
    private final EStructuralFeatureValueConverterService converterService;
    private final EMFFormsLocalizationService localizationService;

    @Inject
    public GridControlSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport, EStructuralFeatureValueConverterService converterService, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport);
        this.converterService = converterService;
        this.localizationService = localizationService;
    }

    protected TableViewerCreator<GridTableViewer> getTableViewerCreator() {
        return new GridTableControlSWTRendererTableViewerCreator();
    }

    protected TableViewerSWTBuilder createTableViewerSWTBuilder(Composite parent, IObservableList list, IObservableValue labelText, IObservableValue labelTooltipText, TableViewerCompositeBuilder compositeBuilder, ObservableListContentProvider cp, TableControlSWTRenderer.ECPTableViewerComparator comparator, TableControlSWTRenderer.TableControlSWTRendererButtonBarBuilder tableControlSWTRendererButtonBarBuilder) {
        return (TableViewerSWTBuilder)((TableViewerSWTBuilder)GridTableViewerFactory.fillDefaults(parent, 0, (Object)list, labelText, labelTooltipText).customizeCompositeStructure(compositeBuilder).customizeButtons((ButtonBarBuilder)tableControlSWTRendererButtonBarBuilder).customizeTableViewerCreation(this.getTableViewerCreator()).customizeContentProvider((IContentProvider)cp).customizeComparator((ViewerComparator)comparator).enableFeature(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW)).enableFeature(TableConfiguration.FEATURE_COLUMN_FILTER);
    }

    protected int getSelectionIndex() {
        return ((GridTableViewer)this.getTableViewer()).getGrid().getSelectionIndex();
    }

    protected Item[] getColumns() {
        return ((GridTableViewer)this.getTableViewer()).getGrid().getColumns();
    }

    protected ScrollBar getHorizontalBar() {
        return ((GridTableViewer)this.getTableViewer()).getGrid().getHorizontalBar();
    }

    protected ScrollBar getVerticalBar() {
        return ((GridTableViewer)this.getTableViewer()).getGrid().getVerticalBar();
    }

    protected int computeRequiredHeight(Integer visibleLines) {
        if (this.getTableViewer() == null || this.getTableViewerComposite() == null) {
            return -1;
        }
        TableControl table = this.getTableViewerComposite().getTableControl();
        if (table == null) {
            return -1;
        }
        if (table.isDisposed()) {
            return -1;
        }
        int itemHeight = table.getItemHeight() + 1;
        int itemCount = visibleLines != null ? Math.max(visibleLines, 1) : Math.max(table.getItemCount(), 1);
        int headerHeight = table.getHeaderVisible() ? table.getHeaderHeight() : 0;
        int tableHeight = itemHeight * itemCount + headerHeight;
        return tableHeight;
    }

    protected EStructuralFeatureValueConverterService getConverterService() {
        return this.converterService;
    }

    protected EMFFormsLocalizationService getLocalizationService() {
        return this.localizationService;
    }

    private class CopyDragListener
    implements MouseListener,
    ISelectionChangedListener {
        private IStructuredSelection lastSelection;
        private EObject masterObject;
        private final PreSetValidationService preSetValidationService;

        CopyDragListener() {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(PreSetValidationService.class);
            this.preSetValidationService = serviceReference != null ? (PreSetValidationService)bundleContext.getService(serviceReference) : null;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1 && (e.stateMask & 0x20000) != 0 && this.lastSelection != null && this.lastSelection.size() > 1 && this.masterObject != null) {
                EStructuralFeature structuralFeature;
                Object masterValue;
                VDomainModelReference dmr;
                List list;
                block13: {
                    list = this.lastSelection.toList();
                    Grid grid = (Grid)e.widget;
                    dmr = (VDomainModelReference)grid.getColumn(new Point(e.x, e.y)).getData("domain_model_reference");
                    masterValue = null;
                    structuralFeature = null;
                    IObservableValue masterOV = null;
                    try {
                        try {
                            masterOV = GridControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(dmr, this.masterObject);
                            masterValue = masterOV.getValue();
                            structuralFeature = (EStructuralFeature)masterOV.getValueType();
                        }
                        catch (DatabindingFailedException ex) {
                            GridControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                            if (masterOV != null) {
                                masterOV.dispose();
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (masterOV != null) {
                            masterOV.dispose();
                        }
                        throw throwable;
                    }
                    if (masterOV != null) {
                        masterOV.dispose();
                    }
                }
                EditingDomain editingDomain = GridControlSWTRenderer.this.getEditingDomain(this.masterObject);
                CompoundCommand cc = new CompoundCommand();
                ArrayList<String> invalidValues = new ArrayList<String>();
                int i = 0;
                while (i < list.size()) {
                    EObject eObject = (EObject)list.get(i);
                    if (this.masterObject != eObject) {
                        boolean valid;
                        Diagnostic diagnostic = this.validate(eObject, dmr, structuralFeature);
                        boolean bl = valid = diagnostic.getSeverity() == 0;
                        if (!valid) {
                            invalidValues.add(((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
                        } else {
                            Command setCommand = SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)masterValue);
                            cc.append(setCommand);
                        }
                    }
                    ++i;
                }
                editingDomain.getCommandStack().execute((Command)cc);
            }
        }

        private Diagnostic validate(EObject eObject, VDomainModelReference dmr, EStructuralFeature structuralFeature) {
            IObservableValue value = null;
            try {
                if (this.preSetValidationService != null) {
                    Diagnostic diag;
                    value = GridControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(dmr, eObject);
                    LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
                    context.put("rootEObject", ((IObserving)IObserving.class.cast(value)).getObserved());
                    Diagnostic diagnostic = diag = this.preSetValidationService.validate(structuralFeature, value.getValue(), context);
                    return diagnostic;
                }
            }
            catch (DatabindingFailedException ex) {
                GridControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
            }
            finally {
                if (value != null) {
                    value.dispose();
                }
            }
            return Diagnostic.OK_INSTANCE;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!IStructuredSelection.class.isInstance(selection)) {
                this.lastSelection = null;
                return;
            }
            this.lastSelection = (IStructuredSelection)event.getSelection();
            if (this.lastSelection.size() == 1) {
                this.masterObject = (EObject)this.lastSelection.getFirstElement();
            }
        }
    }

    public class CustomGridTableViewer
    extends GridTableViewer {
        public CustomGridTableViewer(Composite parent, int style) {
            super(parent, style);
        }

        public ViewerRow getViewerRowFromItem(Widget item) {
            return super.getViewerRowFromItem(item);
        }
    }

    private class GridColumnViewerEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        private final GridTableViewer gridTableViewer;

        GridColumnViewerEditorActivationStrategy(GridTableViewer gridTableViewer) {
            super((ColumnViewer)gridTableViewer);
            this.gridTableViewer = gridTableViewer;
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (event.eventType == 5 || event.eventType == 3 || event.eventType == 4) {
                return true;
            }
            if (event.eventType == 2 && this.gridTableViewer.isCellEditorActive()) {
                this.gridTableViewer.applyEditorValue();
            }
            if (event.eventType == 1) {
                for (int keyCode : Arrays.asList(262144, 65536)) {
                    if ((event.keyCode & keyCode) == 0 && (event.stateMask & keyCode) == 0) continue;
                    return false;
                }
                if ((event.keyCode & 0x20000) != 0) {
                    return false;
                }
                return !this.isDoNotEnterEditorCode(event.keyCode);
            }
            return false;
        }

        private boolean isDoNotEnterEditorCode(int keyCode) {
            return keyCode == 0x1000001 || keyCode == 0x1000002 || keyCode == 0x1000003 || keyCode == 0x1000004 || keyCode == 9 || keyCode == 127;
        }
    }

    protected class GridTableControlSWTRendererTableViewerCreator
    implements TableViewerCreator<GridTableViewer> {
        protected GridTableControlSWTRendererTableViewerCreator() {
        }

        public GridTableViewer createTableViewer(Composite parent) {
            VTFontPropertiesStyleProperty fontPropertiesStyleProperty;
            VTBackgroundStyleProperty backgroundStyleProperty;
            CustomGridTableViewer tableViewer = new CustomGridTableViewer(parent, 68354);
            tableViewer.getGrid().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
            tableViewer.getGrid().setHeaderVisible(true);
            tableViewer.getGrid().setLinesVisible(true);
            tableViewer.getGrid().setCellSelectionEnabled(true);
            tableViewer.getGrid().setFooterVisible(false);
            this.addKeyListener(tableViewer);
            if (GridControlSWTRenderer.this.getViewModelContext().getContextValue("enableMultiEdit") == Boolean.TRUE) {
                CopyDragListener mdl = new CopyDragListener();
                tableViewer.addSelectionChangedListener(mdl);
                tableViewer.getGrid().addMouseListener((MouseListener)mdl);
            }
            if ((backgroundStyleProperty = GridControlSWTRenderer.this.getBackgroundStyleProperty()).getColor() != null) {
                tableViewer.getGrid().setBackground(GridControlSWTRenderer.this.getSWTColor(backgroundStyleProperty.getColor()));
            }
            if ((fontPropertiesStyleProperty = GridControlSWTRenderer.this.getFontPropertiesStyleProperty()).getColorHEX() != null) {
                tableViewer.getGrid().setForeground(GridControlSWTRenderer.this.getSWTColor(fontPropertiesStyleProperty.getColorHEX()));
            }
            tableViewer.getGrid().setData("org.eclipse.rap.rwt.fixedColumns", (Object)new Integer(1));
            this.createTableViewerEditor(tableViewer);
            return tableViewer;
        }

        protected void addKeyListener(GridTableViewer tableViewer) {
            tableViewer.getGrid().addKeyListener((KeyListener)new GridCopyKeyListener(tableViewer.getGrid().getDisplay()));
            tableViewer.getGrid().addKeyListener((KeyListener)new GridPasteKeyListener(tableViewer.getGrid().getDisplay(), (VControl)GridControlSWTRenderer.this.getVElement(), GridControlSWTRenderer.this.getEMFFormsDatabinding(), GridControlSWTRenderer.this.getConverterService(), GridControlSWTRenderer.this.getLocalizationService(), true));
            tableViewer.getGrid().addKeyListener((KeyListener)new GridClearKeyListener((VControl)GridControlSWTRenderer.this.getVElement(), GridControlSWTRenderer.this.getEMFFormsDatabinding()));
            tableViewer.getGrid().addKeyListener((KeyListener)new GridCutKeyListener(tableViewer.getGrid().getDisplay(), (VControl)GridControlSWTRenderer.this.getVElement(), GridControlSWTRenderer.this.getEMFFormsDatabinding()));
        }

        protected void createTableViewerEditor(GridTableViewer gridTableViewer) {
            GridColumnViewerEditorActivationStrategy actSupport = new GridColumnViewerEditorActivationStrategy(gridTableViewer);
            actSupport.setEnableEditorActivationWithKeyboard(true);
            GridViewerEditor.create((GridTableViewer)gridTableViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        }
    }
}

