/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.observable.DelayedObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.common.callback.ViewModelPropertiesUpdateCallback;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailCache;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTCustomization;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeWidthProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.DetailPanelRenderingFinishedCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public class TreeMasterDetailComposite
extends Composite
implements IEditingDomainProvider {
    private final Object input;
    private final EditingDomain editingDomain;
    private TreeViewer treeViewer;
    private Sash verticalSash;
    private Composite detailComposite;
    private Composite detailPanel;
    private ECPSWTView renderedView;
    private final Shell limbo;
    private Object lastRenderedObject;
    private final TreeMasterDetailSWTCustomization customization;
    private TreeMasterDetailCache cache = new TreeMasterDetailCache(){

        @Override
        public boolean isChached(EObject selection) {
            return false;
        }

        @Override
        public ECPSWTView getCachedView(EObject selection) {
            return null;
        }

        @Override
        public void cache(ECPSWTView ecpView) {
            ecpView.dispose();
        }
    };
    private final int renderDelay;
    private ViewModelPropertiesUpdateCallback viewModelPropertiesUpdateCallback;
    private final Set<DetailPanelRenderingFinishedCallback> detailPanelRenderingFinishedCallbacks = new LinkedHashSet<DetailPanelRenderingFinishedCallback>();
    private static VViewModelProperties context = VViewFactory.eINSTANCE.createViewModelLoadingProperties();

    static {
        context.addNonInheritableProperty("detail", (Object)true);
    }

    TreeMasterDetailComposite(Composite parent, int style, Object input, TreeMasterDetailSWTCustomization customization, int renderDelay) {
        super(parent, style);
        this.input = input;
        this.editingDomain = input instanceof Resource ? AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)((Resource)input).getContents().get(0))) : (input instanceof RootObject ? AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((RootObject)RootObject.class.cast(input)).getRoot()) : AdapterFactoryEditingDomain.getEditingDomainFor((Object)input));
        this.renderDelay = renderDelay;
        this.customization = customization;
        this.limbo = new Shell(Display.getCurrent(), 0);
        this.limbo.setLocation(0, 10000);
        this.limbo.setBackground(Display.getDefault().getSystemColor(1));
        this.limbo.setBackgroundMode(2);
        this.renderControl(customization);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeMasterDetailComposite.this.dispose();
            }
        });
    }

    private Control renderControl(TreeMasterDetailSWTCustomization buildBehaviour) {
        this.setLayout((Layout)new FormLayout());
        this.verticalSash = this.createSash(this, buildBehaviour);
        Composite treeComposite = new Composite((Composite)this, 0);
        this.addTreeViewerLayoutData(treeComposite, this.verticalSash);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeComposite);
        this.treeViewer = TreeViewerSWTFactory.createTreeViewer(treeComposite, this.input, this.customization);
        this.detailComposite = buildBehaviour.createDetailComposite(this);
        this.addDetailCompositeLayoutData(this.detailComposite, this.verticalSash);
        final IViewerObservableValue treeViewerSelectionObservable = ViewersObservables.observeSingleSelection((Viewer)this.treeViewer);
        final DelayedObservableValue delayedObservableValue = new DelayedObservableValue(this.renderDelay, (IObservableValue)treeViewerSelectionObservable);
        delayedObservableValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TreeMasterDetailComposite.this.doUpdateDetailPanel(false);
            }
        });
        treeComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                treeViewerSelectionObservable.dispose();
                delayedObservableValue.dispose();
            }
        });
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    TreeMasterDetailComposite.this.doUpdateDetailPanel(true);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeMasterDetailComposite.this.doUpdateDetailPanel(true);
            }
        });
        this.updateDetailPanel(false);
        return this;
    }

    private void setFocusToDetail() {
        if (this.renderedView == null || this.renderedView.getSWTControl().isDisposed()) {
            return;
        }
        this.renderedView.getSWTControl().setFocus();
    }

    private void addDetailCompositeLayoutData(Composite detailComposite, Sash verticalSash) {
        FormData detailFormData = new FormData();
        detailFormData.left = new FormAttachment((Control)verticalSash, 2);
        detailFormData.top = new FormAttachment(0, 5);
        detailFormData.bottom = new FormAttachment(100, -5);
        detailFormData.right = new FormAttachment(100, -5);
        detailComposite.setLayoutData((Object)detailFormData);
    }

    private void addTreeViewerLayoutData(Composite treeComposite, Sash verticalSash) {
        FormData treeFormData = new FormData();
        treeFormData.bottom = new FormAttachment(100, -5);
        treeFormData.left = new FormAttachment(0, 5);
        treeFormData.right = new FormAttachment((Control)verticalSash, -2);
        treeFormData.top = new FormAttachment(0, 5);
        treeComposite.setLayoutData((Object)treeFormData);
    }

    private Sash createSash(final Composite parent, TreeWidthProvider buildBehaviour) {
        final Sash sash = new Sash(parent, 512);
        FormData sashFormData = new FormData();
        sashFormData.bottom = new FormAttachment(100, -5);
        sashFormData.left = new FormAttachment(0, buildBehaviour.getInitialTreeWidth());
        sashFormData.top = new FormAttachment(0, 5);
        sash.setLayoutData((Object)sashFormData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                sash.setLocation(e.x, e.y);
                FormData sashFormData = new FormData();
                sashFormData.bottom = new FormAttachment(100, -5);
                sashFormData.left = new FormAttachment(0, e.x);
                sashFormData.top = new FormAttachment(0, 5);
                sash.setLayoutData((Object)sashFormData);
                parent.layout(true);
            }
        });
        return sash;
    }

    public void updateDetailPanel(boolean setFocusToDetail) {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        Object selectedObject = this.getSelectedObject((IStructuredSelection)selection);
        boolean asyncRendering = false;
        if (selectedObject instanceof EObject) {
            this.lastRenderedObject = selectedObject;
            EObject eObject = (EObject)EObject.class.cast(selectedObject);
            if (this.renderedView != null && !this.renderedView.getSWTControl().isDisposed()) {
                this.renderedView.getSWTControl().setParent((Composite)this.limbo);
                this.cache.cache(this.renderedView);
            }
            this.createDetailPanel();
            if (this.cache.isChached(eObject)) {
                this.renderedView = this.cache.getCachedView(eObject);
                this.renderedView.getSWTControl().setParent(this.detailPanel);
                this.detailPanel.layout();
                this.renderedView.getViewModelContext().changeDomainModel(eObject);
                this.updateScrolledComposite();
            } else {
                VView view;
                if (this.viewModelPropertiesUpdateCallback != null) {
                    this.viewModelPropertiesUpdateCallback.updateViewModelProperties(context);
                }
                if ((view = ViewProviderHelper.getView((EObject)((EObject)selectedObject), (VViewModelProperties)context)).getChildren().size() > 0 && view.getChildren().get(0) instanceof VTreeMasterDetail) {
                    VTreeMasterDetail vTreeMasterDetail = (VTreeMasterDetail)view.getChildren().get(0);
                    try {
                        this.renderedView = ECPSWTViewRenderer.INSTANCE.render(this.detailPanel, (EObject)selectedObject, vTreeMasterDetail.getDetailView());
                        this.detailPanel.layout(true, true);
                    }
                    catch (ECPRendererException eCPRendererException) {}
                } else {
                    Label label = new Label(this.detailPanel, 0);
                    label.setText("loading...");
                    GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
                    this.detailPanel.layout(true, true);
                    asyncRendering = true;
                    Display.getDefault().asyncExec((Runnable)new UpdateDetailRunnable(setFocusToDetail, eObject, label));
                }
                this.updateScrolledComposite();
            }
        } else {
            this.renderEmptyDetailPanel();
        }
        if (!asyncRendering) {
            for (DetailPanelRenderingFinishedCallback callback : this.detailPanelRenderingFinishedCallbacks) {
                callback.renderingFinished(selectedObject);
            }
        }
    }

    private Object getSelectedObject(IStructuredSelection selection) {
        Object selectedObject;
        Object object = selectedObject = selection != null ? selection.getFirstElement() : null;
        if (this.customization.enableVerticalCopy() && selectedObject instanceof EObject && selection.size() > 1) {
            boolean allOfSameType = true;
            final EObject dummy = EcoreUtil.create((EClass)((EObject)selectedObject).eClass());
            Iterator iterator = selection.iterator();
            final LinkedHashSet<EObject> selectedEObjects = new LinkedHashSet<EObject>();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                if (!(allOfSameType &= eObject.eClass() == dummy.eClass())) break;
                for (EAttribute attribute : dummy.eClass().getEAllAttributes()) {
                    if (eObject == selectedObject) {
                        dummy.eSet((EStructuralFeature)attribute, eObject.eGet((EStructuralFeature)attribute));
                        continue;
                    }
                    if (dummy.eGet((EStructuralFeature)attribute) == null || dummy.eGet((EStructuralFeature)attribute).equals(eObject.eGet((EStructuralFeature)attribute))) continue;
                    dummy.eUnset((EStructuralFeature)attribute);
                }
                selectedEObjects.add(eObject);
            }
            if (allOfSameType) {
                selectedObject = dummy;
                dummy.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        if (dummy.eClass().getEAllAttributes().contains(notification.getFeature())) {
                            CompoundCommand cc = new CompoundCommand();
                            block4: for (EObject selected : selectedEObjects) {
                                Command command = null;
                                switch (notification.getEventType()) {
                                    case 1: {
                                        command = SetCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)notification.getNewValue());
                                        break;
                                    }
                                    case 2: {
                                        command = SetCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)SetCommand.UNSET_VALUE);
                                        break;
                                    }
                                    default: {
                                        continue block4;
                                    }
                                }
                                cc.append(command);
                            }
                            TreeMasterDetailComposite.this.editingDomain.getCommandStack().execute((Command)cc);
                        }
                    }
                });
            }
        }
        return selectedObject;
    }

    private void updateScrolledComposite() {
        if (ScrolledComposite.class.isInstance(this.detailComposite)) {
            ((ScrolledComposite)ScrolledComposite.class.cast(this.detailComposite)).setMinSize(this.detailPanel.computeSize(-1, -1));
        }
    }

    private void renderEmptyDetailPanel() {
        this.lastRenderedObject = null;
        if (this.renderedView != null && !this.renderedView.getSWTControl().isDisposed()) {
            this.renderedView.getSWTControl().setParent((Composite)this.limbo);
            this.cache.cache(this.renderedView);
            this.renderedView = null;
        }
        this.createDetailPanel();
        Label hint = new Label(this.detailPanel, 0x1000000);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)hint.getFont()).setHeight(18).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)hint.getDisplay());
        hint.setFont(boldFont);
        hint.setForeground(new Color((Device)hint.getDisplay(), 190, 190, 190));
        hint.setText("Select a node in the tree to edit it");
        GridData hintLayoutData = new GridData();
        hintLayoutData.grabExcessVerticalSpace = true;
        hintLayoutData.grabExcessHorizontalSpace = true;
        hintLayoutData.horizontalAlignment = 0x1000000;
        hintLayoutData.verticalAlignment = 0x1000000;
        hint.setLayoutData((Object)hintLayoutData);
        this.detailPanel.pack();
        this.detailPanel.layout(true, true);
        this.updateScrolledComposite();
    }

    private Control createDetailPanel() {
        if (this.detailPanel != null) {
            this.detailPanel.dispose();
        }
        this.detailPanel = new Composite(this.detailComposite, 2048);
        this.detailPanel.setLayout((Layout)new GridLayout());
        this.detailPanel.setBackground(new Color((Device)Display.getDefault(), new RGB(255, 255, 255)));
        this.detailPanel.setBackgroundMode(2);
        if (ScrolledComposite.class.isInstance(this.detailComposite)) {
            ((ScrolledComposite)ScrolledComposite.class.cast(this.detailComposite)).setContent((Control)this.detailPanel);
        }
        this.detailComposite.layout(true, true);
        return this.detailPanel;
    }

    public void dispose() {
        this.limbo.dispose();
        this.customization.dispose();
        super.dispose();
    }

    public Object getCurrentSelection() {
        if (!(this.treeViewer.getSelection() instanceof StructuredSelection)) {
            return null;
        }
        return ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public void setSelection(ISelection structuredSelection) {
        this.treeViewer.setSelection(structuredSelection);
    }

    public TreeViewer getSelectionProvider() {
        return this.treeViewer;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void setCache(TreeMasterDetailCache cache) {
        if (cache != null) {
            this.cache = cache;
        }
    }

    private void doUpdateDetailPanel(boolean setFocusToDetail) {
        if (this.lastRenderedObject == this.getCurrentSelection()) {
            if (setFocusToDetail) {
                this.setFocusToDetail();
            }
            return;
        }
        this.updateDetailPanel(setFocusToDetail);
    }

    public void addViewModelPropertiesUpdateCallback(ViewModelPropertiesUpdateCallback viewModelPropertiesUpdateCallback) {
        this.viewModelPropertiesUpdateCallback = viewModelPropertiesUpdateCallback;
    }

    public boolean registerDetailPanelRenderingFinishedCallback(DetailPanelRenderingFinishedCallback detailPanelRenderingFinishedCallback) {
        return this.detailPanelRenderingFinishedCallbacks.add(detailPanelRenderingFinishedCallback);
    }

    public boolean unregisterDetailPanelRenderingFinishedCallback(DetailPanelRenderingFinishedCallback detailPanelRenderingFinishedCallback) {
        return this.detailPanelRenderingFinishedCallbacks.remove(detailPanelRenderingFinishedCallback);
    }

    private final class UpdateDetailRunnable
    implements Runnable {
        private final boolean setFocusToDetail;
        private final EObject eObject;
        private final Label label;

        UpdateDetailRunnable(boolean setFocusToDetail, EObject eObject, Label label) {
            this.setFocusToDetail = setFocusToDetail;
            this.eObject = eObject;
            this.label = label;
        }

        @Override
        public void run() {
            try {
                if (TreeMasterDetailComposite.this.viewModelPropertiesUpdateCallback != null) {
                    TreeMasterDetailComposite.this.viewModelPropertiesUpdateCallback.updateViewModelProperties(context);
                }
                VView view = ViewProviderHelper.getView((EObject)this.eObject, (VViewModelProperties)context);
                ViewModelContext modelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, this.eObject, TreeMasterDetailComposite.this.customization.getViewModelServices(view, this.eObject));
                if (TreeMasterDetailComposite.this.limbo.isDisposed()) {
                    return;
                }
                TreeMasterDetailComposite.this.renderedView = ECPSWTViewRenderer.INSTANCE.render((Composite)TreeMasterDetailComposite.this.limbo, modelContext);
                this.label.dispose();
                if (TreeMasterDetailComposite.this.detailPanel.isDisposed()) {
                    return;
                }
                TreeMasterDetailComposite.this.renderedView.getSWTControl().setParent(TreeMasterDetailComposite.this.detailPanel);
                TreeMasterDetailComposite.this.detailPanel.layout(true, true);
                if (ScrolledComposite.class.isInstance(TreeMasterDetailComposite.this.detailComposite)) {
                    ((ScrolledComposite)ScrolledComposite.class.cast(TreeMasterDetailComposite.this.detailComposite)).setMinSize(TreeMasterDetailComposite.this.detailPanel.computeSize(-1, -1));
                }
                if (this.setFocusToDetail) {
                    TreeMasterDetailComposite.this.setFocusToDetail();
                }
                for (DetailPanelRenderingFinishedCallback callback : TreeMasterDetailComposite.this.detailPanelRenderingFinishedCallbacks) {
                    callback.renderingFinished(this.eObject);
                }
            }
            catch (ECPRendererException eCPRendererException) {
                // empty catch block
            }
        }
    }
}

