/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.swt;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.categorization.swt.ValidationTabImageHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.tab.model.VTTabStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSWTTabRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private final Map<CTabItem, VAbstractCategorization> itemToCategorizationMap = new LinkedHashMap<CTabItem, VAbstractCategorization>();
    private final Map<VAbstractCategorization, CTabItem> categorizationToItemMap = new LinkedHashMap<VAbstractCategorization, CTabItem>();
    private final Map<CTabItem, Composite> itemToCompositeMap = new LinkedHashMap<CTabItem, Composite>();
    private final EMFFormsRendererFactory emfFormsRendererFactory;
    private final EMFDataBindingContext dataBindingContext;
    private final VTViewTemplateProvider viewTemplateProvider;

    private EMFFormsRendererFactory getEMFFormsRendererFactory() {
        return this.emfFormsRendererFactory;
    }

    public AbstractSWTTabRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory emfFormsRendererFactory, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService);
        this.emfFormsRendererFactory = emfFormsRendererFactory;
        this.viewTemplateProvider = viewTemplateProvider;
        this.dataBindingContext = new EMFDataBindingContext();
    }

    protected final VTViewTemplateProvider getViewTemplateProvider() {
        return this.viewTemplateProvider;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        boolean useScrolledContent = this.useScrolledContent();
        final CTabFolder folder = new CTabFolder(parent, this.getTabFolderStyle());
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSWTTabRenderer.this.itemSelected(folder.getSelection());
            }
        });
        folder.setBackground(parent.getBackground());
        EList<VAbstractCategorization> categorizations = this.getCategorizations();
        for (VAbstractCategorization categorization : categorizations) {
            ScrolledComposite composite;
            CTabItem item = new CTabItem(folder, 0);
            if (useScrolledContent) {
                composite = new ScrolledComposite((Composite)folder, 768);
            } else {
                composite = new Composite((Composite)folder, 0);
                GridLayoutFactory.fillDefaults().applyTo((Composite)composite);
            }
            this.itemToCategorizationMap.put(item, categorization);
            this.categorizationToItemMap.put(categorization, item);
            this.itemToCompositeMap.put(item, (Composite)composite);
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)categorization);
            IObservableValue modelLabelValue = EMFEditObservables.observeValue((EditingDomain)editingDomain, (EObject)categorization, (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
            ISWTObservableValue targetLabelValue = WidgetProperties.text().observe((Widget)item);
            this.dataBindingContext.bindValue((IObservableValue)targetLabelValue, modelLabelValue);
            IObservableValue modelTooltipValue = EMFEditObservables.observeValue((EditingDomain)editingDomain, (EObject)categorization, (EStructuralFeature)VViewPackage.eINSTANCE.getHasTooltip_Tooltip());
            ISWTObservableValue targetTooltipValue = WidgetProperties.tooltipText().observe((Widget)item);
            this.dataBindingContext.bindValue((IObservableValue)targetTooltipValue, modelTooltipValue);
            if (!this.renderLazy()) {
                this.renderItem(item);
            }
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)item, (VElement)categorization, (String)"tabitem", (ViewModelContext)this.getViewModelContext());
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)composite, (VElement)categorization, (String)"tabitem-composite", (ViewModelContext)this.getViewModelContext());
        }
        if (folder.getItemCount() > 0) {
            folder.setSelection(0);
            this.itemSelected(folder.getSelection());
        }
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)folder, (VElement)this.getVElement(), (String)"tabfolder", (ViewModelContext)this.getViewModelContext());
        return folder;
    }

    private void renderItem(CTabItem item) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        AbstractSWTRenderer renderer;
        if (!this.itemToCategorizationMap.containsKey(item)) {
            return;
        }
        VAbstractCategorization categorization = this.itemToCategorizationMap.remove(item);
        Composite composite = this.itemToCompositeMap.remove(item);
        boolean useScrolledContent = this.useScrolledContent();
        try {
            renderer = this.getEMFFormsRendererFactory().getRendererInstance((VElement)categorization, this.getViewModelContext());
        }
        catch (EMFFormsNoRendererException ex) {
            this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{categorization.eClass().getName(), ex}))));
            return;
        }
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        for (SWTGridCell gridCell : gridDescription.getGrid()) {
            Control render = renderer.render(gridCell, composite);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(render);
            if (useScrolledContent) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)ScrolledComposite.class.cast(composite);
                scrolledComposite.setExpandHorizontal(true);
                scrolledComposite.setExpandVertical(true);
                scrolledComposite.setContent(render);
                scrolledComposite.setMinSize(render.computeSize(-1, -1));
            }
            item.setControl((Control)composite);
        }
    }

    protected final void itemSelected(CTabItem selection) {
        try {
            this.renderItem(selection);
        }
        catch (NoRendererFoundException ex) {
            this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{selection.getText(), ex}))));
        }
        catch (NoPropertyDescriptorFoundExeption ex) {
            this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{selection.getText(), ex}))));
        }
    }

    protected boolean useScrolledContent() {
        return true;
    }

    protected boolean renderLazy() {
        return false;
    }

    private Optional<VTTabStyleProperty> getTabStyle() {
        if (this.getViewTemplateProvider() == null) {
            return Optional.empty();
        }
        Set styleProperties = this.getViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTTabStyleProperty.class.isInstance(styleProperty)) continue;
            return Optional.of((Object)((VTTabStyleProperty)VTTabStyleProperty.class.cast(styleProperty)));
        }
        return Optional.empty();
    }

    private int getTabFolderStyle() {
        Optional<VTTabStyleProperty> tabStyle = this.getTabStyle();
        if (!tabStyle.isPresent()) {
            return this.getDefaultFolderStyle();
        }
        VTTabStyleProperty style = (VTTabStyleProperty)tabStyle.get();
        switch (style.getType()) {
            case BOTTOM: {
                return 1024;
            }
            case TOP: {
                return 128;
            }
        }
        return this.getDefaultFolderStyle();
    }

    private int getDefaultFolderStyle() {
        return 1024;
    }

    protected abstract EList<VAbstractCategorization> getCategorizations();

    protected void applyValidation() {
        super.applyValidation();
        for (VAbstractCategorization categorization : this.getCategorizations()) {
            VDiagnostic diagnostic = categorization.getDiagnostic();
            Image image = null;
            if (diagnostic != null) {
                int highestSeverity = diagnostic.getHighestSeverity();
                image = ValidationTabImageHelper.getValidationIcon(this.getTabStyle(), highestSeverity);
            }
            CTabItem tabItem = this.categorizationToItemMap.get(categorization);
            tabItem.setImage(image);
        }
    }

    protected void dispose() {
        this.dataBindingContext.dispose();
        super.dispose();
    }
}

