/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.DiagnosticMessageExtractor;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

public class VDiagnosticImpl
extends EObjectImpl
implements VDiagnostic {
    protected EList<Object> diagnostics;
    private final Map<EObject, Set<Diagnostic>> diagnosticMap = new LinkedHashMap<EObject, Set<Diagnostic>>();

    protected VDiagnosticImpl() {
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (msg.getFeature() != VViewPackage.eINSTANCE.getDiagnostic_Diagnostics()) {
                    return;
                }
                switch (msg.getEventType()) {
                    case 3: {
                        VDiagnosticImpl.this.addNewDiagnostic((Diagnostic)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        if (msg.getNewValue() == null) break;
                        for (Diagnostic diagnostic : (Collection)msg.getNewValue()) {
                            VDiagnosticImpl.this.addNewDiagnostic(diagnostic);
                        }
                        break;
                    }
                    case 4: {
                        VDiagnosticImpl.this.removeOldDiagnostic((Diagnostic)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        if (msg.getOldValue() == null) break;
                        for (Diagnostic diagnostic : (Collection)msg.getOldValue()) {
                            VDiagnosticImpl.this.removeOldDiagnostic(diagnostic);
                        }
                        break;
                    }
                }
            }
        });
    }

    private void removeOldDiagnostic(Diagnostic diagnostic) {
        if (diagnostic == null) {
            return;
        }
        EObject eObject = (EObject)diagnostic.getData().get(0);
        if (!this.diagnosticMap.containsKey(eObject)) {
            return;
        }
        Set<Diagnostic> diagnostics = this.diagnosticMap.get(eObject);
        diagnostics.remove(diagnostic);
        if (diagnostics.size() == 0) {
            this.diagnosticMap.remove(eObject);
        }
    }

    private void addNewDiagnostic(Diagnostic diagnostic) {
        EObject eObject;
        if (diagnostic == null) {
            return;
        }
        EObject parent = eObject = (EObject)diagnostic.getData().get(0);
        while (parent != null) {
            if (!this.diagnosticMap.containsKey(parent)) {
                this.diagnosticMap.put(parent, new LinkedHashSet());
            }
            this.diagnosticMap.get(parent).add(diagnostic);
            parent = parent.eContainer();
        }
    }

    protected EClass eStaticClass() {
        return VViewPackage.Literals.DIAGNOSTIC;
    }

    @Override
    public EList<Object> getDiagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new EDataTypeUniqueEList(Object.class, (InternalEObject)this, 0);
        }
        return this.diagnostics;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDiagnostics();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getDiagnostics().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (diagnostics: ");
        result.append(this.diagnostics);
        result.append(')');
        return result.toString();
    }

    @Override
    public int getHighestSeverity() {
        int highestSeverity = 0;
        if (this.getDiagnostics().size() > 0) {
            for (Object o : this.getDiagnostics()) {
                Diagnostic diagnostic = (Diagnostic)o;
                int n = highestSeverity = highestSeverity >= diagnostic.getSeverity() ? highestSeverity : diagnostic.getSeverity();
            }
        }
        return highestSeverity;
    }

    @Override
    public String getMessage() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(this.getDiagnostics().size());
        for (Object o : this.getDiagnostics()) {
            Diagnostic diagnostic = (Diagnostic)o;
            diagnostics.add(diagnostic);
        }
        return DiagnosticMessageExtractor.getMessage(diagnostics);
    }

    private void sortDiagnostics(List<Diagnostic> diagnostics) {
        Collections.sort(diagnostics, new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic o1, Diagnostic o2) {
                if (o1.getSeverity() != o2.getSeverity()) {
                    return o2.getSeverity() - o1.getSeverity();
                }
                return o1.getMessage().compareTo(o2.getMessage());
            }
        });
    }

    @Override
    public List<Diagnostic> getDiagnostics(EObject eObject) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        Set<Diagnostic> set = this.diagnosticMap.get(eObject);
        if (set != null) {
            for (Diagnostic objectDiagnostic : set) {
                Diagnostic diagnostic = objectDiagnostic;
                if (diagnostic.getSeverity() == 0) continue;
                result.addAll(this.getDiagnostics(diagnostic, eObject));
            }
        }
        this.sortDiagnostics(result);
        return result;
    }

    private List<Diagnostic> getDiagnostics(Diagnostic diagnostic, EObject eObject) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        if (diagnostic.getData() != null && diagnostic.getData().size() != 0 && EcoreUtil.isAncestor((EObject)eObject, (EObject)((EObject)diagnostic.getData().get(0)))) {
            result.add(diagnostic);
        }
        return result;
    }

    @Override
    public List<Diagnostic> getDiagnostic(EObject eObject, EStructuralFeature eStructuralFeature) {
        BasicEList result = new BasicEList();
        Set<Diagnostic> set = this.diagnosticMap.get(eObject);
        if (set != null) {
            for (Diagnostic objectDiagnostic : set) {
                Diagnostic diagnostic = objectDiagnostic;
                if (diagnostic.getSeverity() == 0) continue;
                result.addAll(this.getDiagnostics(diagnostic, eObject, eStructuralFeature));
            }
        }
        this.sortDiagnostics((List<Diagnostic>)result);
        return result;
    }

    private List<Diagnostic> getDiagnostics(Diagnostic diagnostic, EObject eObject, EStructuralFeature eStructuralFeature) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        if (diagnostic.getData() != null && diagnostic.getData().size() > 1 && EcoreUtil.isAncestor((EObject)eObject, (EObject)((EObject)diagnostic.getData().get(0))) && eStructuralFeature.equals(diagnostic.getData().get(1))) {
            if (diagnostic.getChildren() == null || diagnostic.getChildren().size() == 0) {
                result.add(diagnostic);
            } else {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    if (childDiagnostic.getSeverity() == 0) continue;
                    result.add(childDiagnostic);
                }
            }
        }
        return result;
    }
}

