/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.internal.swt.table.util.StaticCellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.AbstractFeatureAwareBuilder;
import org.eclipse.emfforms.spi.swt.table.CellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.ColumnConfigurationImpl;
import org.eclipse.emfforms.spi.swt.table.ConfigurationCallback;
import org.eclipse.emfforms.spi.swt.table.EditingSupportCreator;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;

public final class ColumnConfigurationBuilder
extends AbstractFeatureAwareBuilder<ColumnConfigurationBuilder> {
    private final Set<Feature> features = new LinkedHashSet<Feature>();
    private boolean resizeable = true;
    private boolean moveable;
    private int styleBits = 0;
    private int weight = -1;
    private int minWidth;
    private IObservableValue textObservable;
    private IObservableValue tooltipObservable;
    private CellLabelProviderFactory labelProviderFactory;
    private EditingSupportCreator editingSupportCreator;
    private Image image;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();
    private List<ConfigurationCallback<AbstractTableViewer, ViewerColumn>> configurationCallbacks;

    private ColumnConfigurationBuilder() {
    }

    public static ColumnConfigurationBuilder usingDefaults() {
        return new ColumnConfigurationBuilder();
    }

    public static ColumnConfigurationBuilder usingConfiguration(ColumnConfiguration columnConfiguration) {
        return new ColumnConfigurationBuilder(columnConfiguration);
    }

    private ColumnConfigurationBuilder(ColumnConfiguration columnConfiguration) {
        ColumnConfigurationImpl config = (ColumnConfigurationImpl)columnConfiguration;
        this.resizable(config.isResizeable());
        this.moveable(config.isMoveable());
        this.styleBits(config.getStyleBits());
        this.weight(config.getWeight());
        this.minWidth(config.getMinWidth());
        this.labelProviderFactory(config.getLabelProviderFactory());
        if (config.getEditingSupportCreator().isPresent()) {
            this.editingSupportCreator((EditingSupportCreator)config.getEditingSupportCreator().get());
        }
        this.configurationCallbacks = config.getConfigurationCallbacks();
    }

    @Override
    public Set<Feature> getSupportedFeatures() {
        return new LinkedHashSet<Feature>(Arrays.asList(ColumnConfiguration.FEATURES));
    }

    @Override
    protected Set<Feature> getEnabledFeatures() {
        return this.features;
    }

    public ColumnConfigurationBuilder resizable(boolean resizable) {
        this.resizeable = resizable;
        return this;
    }

    public ColumnConfigurationBuilder moveable(boolean moveable) {
        this.moveable = moveable;
        return this;
    }

    public ColumnConfigurationBuilder styleBits(int styleBits) {
        this.styleBits = styleBits;
        return this;
    }

    public ColumnConfigurationBuilder weight(int weight) {
        this.weight = weight;
        return this;
    }

    public ColumnConfigurationBuilder minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public ColumnConfigurationBuilder text(IObservableValue textObservable) {
        this.textObservable = textObservable;
        return this;
    }

    public ColumnConfigurationBuilder text(String text) {
        return this.text(Observables.constantObservableValue((Object)text, String.class));
    }

    public ColumnConfigurationBuilder tooltip(IObservableValue tooltipObservable) {
        this.tooltipObservable = tooltipObservable;
        return this;
    }

    public ColumnConfigurationBuilder tooltip(String tooltip) {
        return this.tooltip(Observables.constantObservableValue((Object)tooltip, String.class));
    }

    public ColumnConfigurationBuilder labelProviderFactory(CellLabelProviderFactory labelProviderFactory) {
        this.labelProviderFactory = labelProviderFactory;
        return this;
    }

    public ColumnConfigurationBuilder labelProvider(CellLabelProvider labelProvider) {
        return this.labelProviderFactory(new StaticCellLabelProviderFactory(labelProvider));
    }

    public ColumnConfigurationBuilder editingSupportCreator(EditingSupportCreator editingSupportCreator) {
        this.editingSupportCreator = editingSupportCreator;
        return this;
    }

    public ColumnConfigurationBuilder image(Image image) {
        this.image = image;
        return this;
    }

    public ColumnConfigurationBuilder dataMap(Map<String, Object> data) {
        if (!this.data.isEmpty()) {
            throw new IllegalArgumentException("Data map values have already been set");
        }
        if (data == null) {
            throw new NullPointerException("Data map cannot be null");
        }
        this.data = data;
        return this;
    }

    public ColumnConfigurationBuilder dataMapEntry(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public ColumnConfigurationBuilder callback(ConfigurationCallback<AbstractTableViewer, ViewerColumn> callback) {
        if (this.configurationCallbacks == null) {
            this.configurationCallbacks = new ArrayList<ConfigurationCallback<AbstractTableViewer, ViewerColumn>>();
        }
        this.configurationCallbacks.add(callback);
        return this;
    }

    public ColumnConfiguration build() {
        ColumnConfigurationImpl config = new ColumnConfigurationImpl(this.features, this.resizeable, this.moveable, this.styleBits, this.weight, this.minWidth, this.textObservable, this.tooltipObservable, this.labelProviderFactory, this.editingSupportCreator, this.image, this.data, this.configurationCallbacks);
        return config;
    }
}

