/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.declaration.LibraryImplementation;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.internal.common.ResourceSetFactoryImpl;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.declaration.OperationRegistry;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.internal.ClassLoaderFacade;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigrationReconstructor;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigratorCommandLine;
import org.eclipse.emf.edapt.internal.migration.execution.internal.WrappedMigrationException;
import org.eclipse.emf.edapt.internal.migration.internal.BackupUtils;
import org.eclipse.emf.edapt.internal.migration.internal.MaterializingBackwardConverter;
import org.eclipse.emf.edapt.internal.migration.internal.Persistency;
import org.eclipse.emf.edapt.internal.migration.internal.PrintStreamProgressMonitor;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

public class Migrator {
    private History history;
    private HashMap<String, java.util.Set<Release>> releaseMap;
    private final IClassLoader classLoader;
    private IResourceSetFactory resourceSetFactory = new ResourceSetFactoryImpl();
    private ValidationLevel level = ValidationLevel.CUSTOM_MIGRATION;

    public Migrator(URI historyURI, IClassLoader classLoader) throws MigrationException {
        HistoryPackage.eINSTANCE.getHistory();
        try {
            this.history = (History)ResourceUtils.loadElement((URI)historyURI);
        }
        catch (IOException e) {
            throw new MigrationException("History could not be loaded", (Throwable)e);
        }
        this.classLoader = classLoader;
        this.init();
    }

    public Migrator(History history, IClassLoader classLoader) {
        this.history = history;
        this.classLoader = classLoader;
        this.init();
    }

    private void init() {
        this.releaseMap = new HashMap();
        HashMap<EPackage, String> packageMap = new HashMap<EPackage, String>();
        for (Release release : this.history.getReleases()) {
            if (release.isLastRelease()) continue;
            this.updatePackages(release, packageMap);
            this.registerRelease(release, packageMap);
        }
    }

    private void registerRelease(Release release, Map<EPackage, String> packageMap) {
        for (Map.Entry<EPackage, String> entry : packageMap.entrySet()) {
            String nsURI = entry.getValue();
            java.util.Set<Release> releases = this.releaseMap.get(nsURI);
            if (releases == null) {
                releases = new HashSet<Release>();
                this.releaseMap.put(nsURI, releases);
            }
            releases.add(release);
        }
    }

    private void updatePackages(Release release, Map<EPackage, String> packageMap) {
        TreeIterator i = release.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (element instanceof Set) {
                Set set = (Set)element;
                if (set.getFeature() != EcorePackage.eINSTANCE.getEPackage_NsURI()) continue;
                EPackage ePackage = (EPackage)set.getElement();
                String nsURI = (String)set.getValue();
                packageMap.put(ePackage, nsURI);
                continue;
            }
            if (!(element instanceof Delete)) continue;
            Delete delete = (Delete)element;
            packageMap.remove(delete.getElement());
        }
    }

    public void migrateAndSave(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        this.migrateAndSave(modelURIs, sourceRelease, targetRelease, monitor, null);
    }

    public void migrateAndSave(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor, Map<String, Object> options) throws MigrationException {
        Model model = this.migrate(modelURIs, sourceRelease, targetRelease, monitor);
        if (model == null) {
            throw new MigrationException("Model is up-to-date", null);
        }
        try {
            Persistency.saveModel((Model)model, options);
        }
        catch (IOException e) {
            throw new MigrationException("Model could not be saved", (Throwable)e);
        }
    }

    public ResourceSet migrateAndLoad(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        Model model = this.migrate(modelURIs, sourceRelease, targetRelease, monitor);
        if (model == null) {
            return null;
        }
        MaterializingBackwardConverter converter = new MaterializingBackwardConverter();
        return converter.convert(model);
    }

    public Release getLatestRelease() {
        EList<Release> releases = this.history.getReleases();
        return (Release)releases.get(releases.size() - 2);
    }

    private Model migrate(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        try {
            Model model;
            if (targetRelease == null) {
                targetRelease = this.getLatestRelease();
            }
            if (sourceRelease == targetRelease) {
                return null;
            }
            monitor.beginTask("Migrate", this.numberOfSteps(sourceRelease, targetRelease));
            EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"test"));
            MigrationReconstructor migrationReconstructor = new MigrationReconstructor(modelURIs, sourceRelease, targetRelease, monitor, this.classLoader, this.level, this.resourceSetFactory);
            reconstructor.addReconstructor(migrationReconstructor);
            reconstructor.reconstruct(targetRelease, false);
            Model model2 = model = migrationReconstructor.getModel();
            return model2;
        }
        catch (WrappedMigrationException e) {
            throw e.getCause();
        }
        finally {
            monitor.done();
        }
    }

    private int numberOfSteps(Release sourceRelease, Release targetRelease) {
        int size = 0;
        boolean inRelease = false;
        for (Release release : this.history.getReleases()) {
            if (inRelease) {
                size += release.getChanges().size();
            }
            if (release == sourceRelease) {
                inRelease = true;
            }
            if (release == targetRelease) break;
        }
        return size;
    }

    public java.util.Set<Release> getRelease(URI modelURI) {
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURI);
        return this.releaseMap.containsKey(nsURI) ? this.releaseMap.get(nsURI) : Collections.emptySet();
    }

    public java.util.Set<Release> getRelease(java.util.Set<String> nsURIs) {
        LinkedHashSet<Release> releases = new LinkedHashSet<Release>();
        for (String nsURI : nsURIs) {
            java.util.Set<Release> set = this.getReleaseMap().get(nsURI);
            if (set == null || set.isEmpty()) continue;
            if (releases.isEmpty()) {
                releases.addAll(set);
                continue;
            }
            releases.retainAll(set);
        }
        return releases;
    }

    public Map<String, java.util.Set<Release>> getReleaseMap() {
        return this.releaseMap;
    }

    public Release getRelease(int number) {
        if (number < 0 || number >= this.history.getReleases().size()) {
            return null;
        }
        return (Release)this.history.getReleases().get(number);
    }

    public List<Release> getReleases() {
        ArrayList<Release> releases = new ArrayList<Release>();
        releases.addAll((Collection<Release>)this.history.getReleases());
        releases.remove(this.history.getLastRelease());
        return releases;
    }

    public java.util.Set<String> getNsURIs() {
        return this.releaseMap.keySet();
    }

    public Metamodel getMetamodel(Release release) {
        EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"test"));
        reconstructor.reconstruct(release, false);
        URI metamodelURI = URI.createFileURI((String)new File("metamodel.ecore").getAbsolutePath());
        List rootPackages = ResourceUtils.getRootElements((ResourceSet)reconstructor.getResourceSet(), EPackage.class);
        ResourceSet resourceSet = MetamodelUtils.createIndependentMetamodelCopy((Collection)rootPackages, (URI)metamodelURI);
        return Persistency.loadMetamodel((ResourceSet)resourceSet);
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public static void main(String[] args) {
        MigratorCommandLine commandLine = new MigratorCommandLine(args);
        List<URI> modelURIs = commandLine.getModelURIs();
        int sourceReleaseNumber = commandLine.getSourceReleaseNumber();
        int targetReleaseNumber = commandLine.getTargetReleaseNumber();
        try {
            for (Class<? extends LibraryImplementation> clazz : commandLine.getLibraries()) {
                OperationRegistry.getInstance().registerLibrary(clazz);
            }
            for (Class<? extends LibraryImplementation> clazz : commandLine.getOperations()) {
                OperationRegistry.getInstance().registerOperation(clazz);
            }
            Migrator migrator = new Migrator(commandLine.getHistoryURI(), (IClassLoader)new ClassLoaderFacade(Thread.currentThread().getContextClassLoader()));
            migrator.setLevel(commandLine.getLevel());
            java.util.Set<Release> releases = migrator.getRelease(modelURIs.get(0));
            Release sourceRelease = null;
            sourceRelease = sourceReleaseNumber != -1 ? HistoryUtils.getRelease(releases, sourceReleaseNumber) : releases.iterator().next();
            if (commandLine.isBackup()) {
                Metamodel metamodel = migrator.getMetamodel(sourceRelease);
                try {
                    BackupUtils.backup(modelURIs, (Metamodel)metamodel);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
            Release targetRelease = migrator.getRelease(targetReleaseNumber);
            migrator.migrateAndSave(modelURIs, sourceRelease, targetRelease, (IProgressMonitor)new PrintStreamProgressMonitor(System.out));
        }
        catch (MigrationException migrationException) {
            System.err.println(migrationException.getMessage());
            System.err.println(migrationException.getCause().getMessage());
        }
    }

    public void setResourceSetFactory(IResourceSetFactory resourceSetFactory) {
        if (resourceSetFactory != null) {
            this.resourceSetFactory = resourceSetFactory;
        }
    }

    public IResourceSetFactory getResourceSetFactory() {
        return this.resourceSetFactory;
    }
}

