/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.converter;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverter;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={EStructuralFeatureValueConverterService.class})
public class EStructuralFeatureValueConverterServiceImpl
implements EStructuralFeatureValueConverterService {
    private final Set<EStructuralFeatureValueConverter> converters = new LinkedHashSet<EStructuralFeatureValueConverter>();

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void addValueConverter(EStructuralFeatureValueConverter converter) {
        this.converters.add(converter);
    }

    @Override
    public void removeValueConverter(EStructuralFeatureValueConverter converter) {
        this.converters.remove(converter);
    }

    private EStructuralFeatureValueConverter getHighestRankingConverter(EObject eObject, EStructuralFeature feature, Object value, EStructuralFeatureValueConverter.Direction direction) {
        double priority = -1.0;
        EStructuralFeatureValueConverter highestRankingConverter = null;
        for (EStructuralFeatureValueConverter converter : this.converters) {
            double applicable = converter.isApplicable(eObject, feature, value, direction);
            if (applicable == -1.0 || applicable <= priority) continue;
            highestRankingConverter = converter;
            priority = applicable;
        }
        return highestRankingConverter;
    }

    @Override
    public Object convertToModelValue(EObject eObject, EStructuralFeature feature, String literal) {
        EStructuralFeatureValueConverter converter = this.getHighestRankingConverter(eObject, feature, literal, EStructuralFeatureValueConverter.Direction.LITERAL_TO_MODEL);
        if (converter == null) {
            return null;
        }
        return converter.convertToModelValue(eObject, feature, literal);
    }

    @Override
    public Object convertToLiteral(EObject eObject, EStructuralFeature feature, Object instance) {
        EStructuralFeatureValueConverter converter = this.getHighestRankingConverter(eObject, feature, instance, EStructuralFeatureValueConverter.Direction.MODEL_TO_LITERAL);
        if (converter == null) {
            return null;
        }
        return converter.convertToLiteral(eObject, feature, instance);
    }
}

