/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.controls;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlJFaceViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class DataTypeControl
extends SimpleControlJFaceViewerSWTRenderer {
    @Inject
    public DataTypeControl(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected String getUnsetText() {
        return "No EDataType set!";
    }

    protected Viewer createJFaceViewer(Composite parent) {
        ComboViewer combo = new ComboViewer(parent, 4);
        Class<EClassifier> type = EClassifier.class;
        boolean includeEcorePackage = false;
        if (this.getViewModelContext().getDomainModel() instanceof EAttribute) {
            type = EDataType.class;
            includeEcorePackage = true;
        } else if (this.getViewModelContext().getDomainModel() instanceof EReference) {
            type = EClass.class;
            includeEcorePackage = false;
        } else if (this.getViewModelContext().getDomainModel() instanceof EOperation) {
            includeEcorePackage = true;
        } else if (this.getViewModelContext().getDomainModel() instanceof EParameter) {
            includeEcorePackage = true;
        }
        List classifiers = ResourceSetHelpers.findAllOfTypeInResourceSet((EObject)this.getViewModelContext().getDomainModel(), type, (boolean)includeEcorePackage);
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EClassifier) {
                    return ((EClassifier)element).getName();
                }
                return super.getText(element);
            }
        });
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setInput((Object)classifiers.toArray());
        new AutoCompleteField((Control)combo.getCombo(), (IControlContentAdapter)new ComboContentAdapter(), combo.getCombo().getItems());
        return combo;
    }

    protected Binding[] createBindings(final Viewer viewer) throws DatabindingFailedException {
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)WidgetProperties.text().observe((Widget)((ComboViewer)viewer).getCombo()), this.getModelValue(), new EMFUpdateValueStrategy().setConverter((IConverter)new Converter(String.class, EClassifier.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return null;
                }
                Object[] classifiers = (Object[])((ComboViewer)viewer).getInput();
                int i = 0;
                while (i < classifiers.length) {
                    if (fromObject.equals(((EClassifier)classifiers[i]).getName())) {
                        return classifiers[i];
                    }
                    ++i;
                }
                String fromStringWithE = "E" + fromObject.toString();
                int i2 = 0;
                while (i2 < classifiers.length) {
                    if (fromStringWithE.equals(((EClassifier)classifiers[i2]).getName())) {
                        return classifiers[i2];
                    }
                    ++i2;
                }
                return null;
            }
        }), new EMFUpdateValueStrategy().setConverter((IConverter)new Converter(EClassifier.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return "";
                }
                return ((EClassifier)fromObject).getName();
            }
        }));
        return new Binding[]{binding};
    }

    protected boolean isUnsettable() {
        return false;
    }
}

