/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.ide.internal.builder;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.ide.spi.util.ViewModelHelper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.common.spi.validation.ValidationService;
import org.eclipse.emfforms.common.spi.validation.filter.AbstractComplexFilter;
import org.eclipse.emfforms.common.spi.validation.filter.ValidationFilter;
import org.eclipse.emfforms.ide.builder.ValidationDelegate;
import org.eclipse.emfforms.ide.builder.ValidationDelegateProvider;
import org.eclipse.emfforms.ide.builder.ValidationServiceDelegate;
import org.osgi.service.component.annotations.Component;

public class ViewModelValidationDelegate
extends ValidationServiceDelegate {
    @Override
    protected ResourceSet loadModel(IFile file) throws IOException {
        ResourceSet result = null;
        LinkedHashSet<String> ecores = new LinkedHashSet<String>();
        VView view = ViewModelHelper.loadView((IFile)file, ecores);
        ViewAdapter adapter = new ViewAdapter(view, ecores);
        if (view == null) {
            adapter.dispose();
        } else {
            view.eAdapters().add((Object)adapter);
            result = view.eResource().getResourceSet();
            result.eAdapters().add((Object)adapter);
        }
        return result;
    }

    @Override
    protected EObject getModel(ResourceSet resourceSet) {
        return ViewAdapter.getView(resourceSet);
    }

    @Override
    protected void configure(ValidationService validationService, ResourceSet resourceSet, EObject model) {
        super.configure(validationService, resourceSet, model);
        VView view = (VView)model;
        VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)view);
        view.setLoadingProperties(properties);
        validationService.registerValidationFilter((ValidationFilter)new ViewValidatorDuplicateFilter());
    }

    @Component
    public static class Provider
    implements ValidationDelegateProvider {
        private static final Double BID = 10.0;
        private static final String VIEW = "view";

        @Bid
        public Double bid(IFile file) {
            return Provider.isViewModelResource(file) ? BID : null;
        }

        @Create
        public ValidationDelegate createValidationDelegate() {
            return new ViewModelValidationDelegate();
        }

        private static boolean isViewModelResource(IFile resource) {
            return VIEW.equals(resource.getFileExtension());
        }
    }

    private static final class ViewAdapter
    extends AdapterImpl {
        private final Set<String> ecores;
        private final VView view;

        ViewAdapter(VView view, Set<String> ecores) {
            this.view = view;
            this.ecores = ecores;
        }

        public boolean isAdapterForType(Object type) {
            return type == VView.class || type == ViewAdapter.class;
        }

        public void unsetTarget(Notifier oldTarget) {
            super.unsetTarget(oldTarget);
            this.dispose();
        }

        VView getView() {
            return this.view;
        }

        void dispose() {
            for (String registeredEcore : this.ecores) {
                EcoreHelper.unregisterEcore((String)registeredEcore);
            }
            this.ecores.clear();
        }

        static VView getView(ResourceSet resourceSet) {
            ViewAdapter adapter = (ViewAdapter)EcoreUtil.getExistingAdapter((Notifier)resourceSet, ViewAdapter.class);
            return adapter == null ? null : adapter.getView();
        }
    }

    private class ViewValidatorDuplicateFilter
    extends AbstractComplexFilter {
        private ViewValidatorDuplicateFilter() {
        }

        public boolean skipSubtree(EObject eObject, Optional<Diagnostic> diagnostic) {
            return false;
        }

        public boolean skipValidation(EObject eObject) {
            return VDomainModelReference.class.isInstance(eObject);
        }
    }
}

