/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.core.services.databinding.featurepath;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;

public class FeaturePathDomainModelReferenceConverter
implements DomainModelReferenceConverterEMF {
    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (domainModelReference instanceof VFeaturePathDomainModelReference) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private VFeaturePathDomainModelReference checkAndConvertDMR(VDomainModelReference domainModelReference) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VFeaturePathDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VFeaturePathDomainModelReference.");
        }
        VFeaturePathDomainModelReference featurePathReference = (VFeaturePathDomainModelReference)domainModelReference;
        if (featurePathReference.getDomainModelEFeature() == null) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VFeaturePathDomainModelReference must not be null.");
        }
        if (featurePathReference.getDomainModelEFeature().eIsProxy()) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VFeaturePathDomainModelReference must not be a proxy.");
        }
        return featurePathReference;
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EditingDomain editingDomain = this.getEditingDomain(object);
        return this.convertToValueProperty(domainModelReference, null, editingDomain);
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        VFeaturePathDomainModelReference featurePathReference = this.checkAndConvertDMR(domainModelReference);
        EList referencePath = featurePathReference.getDomainModelEReferencePath();
        if (referencePath.isEmpty()) {
            return EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)featurePathReference.getDomainModelEFeature());
        }
        if (((EReference)referencePath.get(0)).isMany()) {
            throw new DatabindingFailedException(String.format("The path is not fully resolved. The reference being resolved is not a single reference [%1$s]. The DMR is %2$s.", referencePath.get(0), domainModelReference));
        }
        IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
        int i = 1;
        while (i < referencePath.size()) {
            EReference eReference = (EReference)referencePath.get(i);
            if (eReference.isMany()) {
                throw new DatabindingFailedException(String.format("The path is not fully resolved. The reference being resolved is not a single reference [%1$s]. The DMR is %2$s.", eReference, domainModelReference));
            }
            emfValueProperty = emfValueProperty.value((EStructuralFeature)eReference);
            ++i;
        }
        return emfValueProperty.value(featurePathReference.getDomainModelEFeature());
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }

    public IEMFListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        VFeaturePathDomainModelReference featurePathReference = this.checkAndConvertDMR(domainModelReference);
        EList referencePath = featurePathReference.getDomainModelEReferencePath();
        EditingDomain editingDomain = this.getEditingDomain(object);
        if (referencePath.isEmpty()) {
            return EMFEditProperties.list((EditingDomain)editingDomain, (EStructuralFeature)featurePathReference.getDomainModelEFeature());
        }
        IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
        int i = 1;
        while (i < referencePath.size()) {
            emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
            ++i;
        }
        return emfValueProperty.list(featurePathReference.getDomainModelEFeature());
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        VFeaturePathDomainModelReference featurePathReference = this.checkAndConvertDMR(domainModelReference);
        EObject currentObject = object;
        for (EReference eReference : featurePathReference.getDomainModelEReferencePath()) {
            if (eReference.isMany()) {
                throw new DatabindingFailedException(String.format("The path is not fully resolved. The reference being resolved is not a single reference [%1$s]. The DMR is %2$s. Last resolved EObject is %3$s.", eReference, domainModelReference, currentObject));
            }
            if (currentObject.eClass().getFeatureID((EStructuralFeature)eReference) == -1) {
                throw new DatabindingFailedException(String.format("Given EClass has no such feature. The DMR is %1$s. Last resolved EObject is %2$s. Reference being resolved is %3$s.", domainModelReference, currentObject, eReference));
            }
            EObject nextObject = (EObject)currentObject.eGet((EStructuralFeature)eReference);
            if (nextObject == null) {
                throw new DatabindingFailedException(String.format("The path is not fully resolved. The DMR is %1$s. Last resolved EObject is %2$s. Reference being resolved is %3$s.", domainModelReference, currentObject, eReference));
            }
            currentObject = nextObject;
        }
        EStructuralFeature structuralFeature = featurePathReference.getDomainModelEFeature();
        if (structuralFeature.getEType() == null) {
            throw new DatabindingFailedException(String.format("The eType of the feature %1$s is null.", structuralFeature.getName()));
        }
        if (currentObject.eClass().getEAllStructuralFeatures().contains((Object)structuralFeature)) {
            return ((InternalEObject)InternalEObject.class.cast(currentObject)).eSetting(structuralFeature);
        }
        throw new DatabindingFailedException(String.format("The resolved Object %1$s doesn't contain the feature %2$s.", currentObject.eClass().getName(), structuralFeature.getName()));
    }
}

