/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.io.IOException;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.view.control.multiattribute.MultiAttributeSWTRenderer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class EcorePathsRenderer
extends MultiAttributeSWTRenderer {
    private Composite parent;
    private IObservableList list;

    @Inject
    public EcorePathsRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService);
    }

    public void finalizeRendering(Composite parent) {
        super.finalizeRendering(parent);
        this.parent = parent;
    }

    protected void initButtons(IObservableList list) {
        this.list = list;
        super.initButtons(list);
    }

    protected Object getValueForNewRow(EAttribute attribute) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getType() == 1 && "ecore".equalsIgnoreCase(file.getFileExtension())) {
                    if (EcorePathsRenderer.this.list.contains((Object)file.getFullPath().toString())) {
                        return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", 4, MessageFormat.format(LocalizationServiceHelper.getString(EcorePathsRenderer.class, (String)"EcorePath_AddDialog_Status_AlreadyAdded"), file.getName()), null);
                    }
                    return new Status(0, "org.eclipse.emf.ecp.view.editor.controls", 0, null, null);
                }
                return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", 4, LocalizationServiceHelper.getString(EcorePathsRenderer.class, (String)"EcorePath_AddDialog_Status_NotEcore"), null);
            }
        });
        dialog.setTitle(LocalizationServiceHelper.getString(EcorePathsRenderer.class, (String)"EcorePath_AddDialog_Title"));
        dialog.setMessage(LocalizationServiceHelper.getString(EcorePathsRenderer.class, (String)"EcorePath_AddDialog_Message"));
        if (dialog.open() == 0) {
            String path = ((IFile)dialog.getFirstResult()).getFullPath().toString();
            try {
                EcoreHelper.registerEcore((String)path);
            }
            catch (IOException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
                return null;
            }
            return path;
        }
        return null;
    }

    protected void postRemove(IStructuredSelection selection) {
        for (Object toDelete : selection.toList()) {
            EcoreHelper.unregisterEcore((String)toDelete.toString());
        }
    }

    protected void createUpDownButtons(Composite composite, IObservableList list) {
    }
}

