/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.view.indexsegment.model.VIndexDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="IndexSegmentExpander")
public class IndexSegmentExpander
implements EMFFormsDMRSegmentExpander {
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Optional<EObject> prepareDomainObject(VDomainModelReferenceSegment segment, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)segment).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)segment).ofClass(VIndexDomainModelReferenceSegment.class);
        VIndexDomainModelReferenceSegment indexSegment = (VIndexDomainModelReferenceSegment)segment;
        EStructuralFeature structuralFeature = domainObject.eClass().getEStructuralFeature(indexSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new EMFFormsExpandingFailedException(String.format("The given domain object does not contain the segment's feature. The segment was %1$s. The domain object was %2$s.", segment, domainObject));
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new EMFFormsExpandingFailedException(String.format("The feature described by the given segment must be an EReference. The segment was %1$s.", segment));
        }
        EReference reference = (EReference)structuralFeature;
        if (!reference.isMany()) {
            throw new EMFFormsExpandingFailedException(String.format("The EReference described by the given index segment must be a multi reference. The segment was %1$s.", segment));
        }
        int index = indexSegment.getIndex();
        EList list = (EList)domainObject.eGet((EStructuralFeature)reference);
        if (list.size() <= index) {
            this.checkReferenceInstantiable(segment, reference);
            int iterations = index - list.size() + 1;
            int i = 0;
            while (i < iterations) {
                EObject newElement = EcoreUtil.create((EClass)reference.getEReferenceType());
                list.add((Object)newElement);
                ++i;
            }
        } else if (list.get(index) == null) {
            this.checkReferenceInstantiable(segment, reference);
            EObject newElement = EcoreUtil.create((EClass)reference.getEReferenceType());
            list.set(index, (Object)newElement);
        }
        EObject target = (EObject)list.get(indexSegment.getIndex());
        return Optional.ofNullable(target);
    }

    private void checkReferenceInstantiable(VDomainModelReferenceSegment segment, EReference reference) throws EMFFormsExpandingFailedException {
        if (reference.getEReferenceType().isAbstract() || reference.getEReferenceType().isInterface()) {
            throw new EMFFormsExpandingFailedException(String.format("The reference type of the segment's feature is either abstract or an interface. Therefore, no instance can be created. The segment was %1$s.", segment));
        }
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("The given domain model reference segment was null.", 2));
            return NOT_APPLICABLE;
        }
        if (VIndexDomainModelReferenceSegment.class.isInstance(segment)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }

    public boolean needsToExpandLastSegment() {
        return false;
    }
}

